/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.Escaper;

final class SymbolEscaper
implements Escaper {
    private final boolean delimit;

    SymbolEscaper() {
        this(false);
    }

    SymbolEscaper(boolean delimit) {
        this.delimit = delimit;
    }

    @Override
    public CharSequence escape(char c) {
        return this.escape(c, true, false);
    }

    private boolean isSymbol(char c, boolean first) {
        if (first) {
            return !Character.isJavaIdentifierStart(c);
        }
        return !Character.isJavaIdentifierPart(c);
    }

    @Override
    public CharSequence escape(char c, int index, int of, char prev) {
        boolean currSymbol = this.isSymbol(c, false);
        if (index != 0) {
            boolean prevSymbol = this.isSymbol(prev, index == 1);
            if (prevSymbol != currSymbol || prevSymbol && currSymbol) {
                return this.escape(c, false, true);
            }
        } else if (!this.delimit && Character.isLetter(c)) {
            if (currSymbol) {
                return this.escape(c, true, false);
            }
            return Character.toString(Character.toUpperCase(c));
        }
        return this.escape(c, index == 0, false);
    }

    public CharSequence escape(char c, boolean first, boolean boundary) {
        if (first) {
            if (Character.isJavaIdentifierStart(c)) {
                if (boundary) {
                    if (this.delimit) {
                        return "_" + c;
                    }
                    if (c == '_') {
                        return "";
                    }
                    return Character.toString(Character.toUpperCase(c));
                }
                return null;
            }
            if (!this.delimit && Character.isJavaIdentifierStart(c)) {
                return Character.toString(Character.toLowerCase(c));
            }
        } else if (Character.isJavaIdentifierPart(c)) {
            if (boundary) {
                if (this.delimit) {
                    return "_" + c;
                }
                return Character.toString(Character.toUpperCase(c));
            }
            if (!this.delimit) {
                if (c == '_') {
                    return "";
                }
                return Character.toString(Character.toLowerCase(c));
            }
            return null;
        }
        String pfx = boundary ? (this.delimit ? "_" : "") : "";
        switch (c) {
            case ' ': {
                return pfx + "Space";
            }
            case '\t': {
                return pfx + "Tab";
            }
            case '\n': {
                return pfx + "Newline";
            }
            case '\r': {
                return pfx + "CarriageReturn";
            }
            case '0': {
                return pfx + "Zero";
            }
            case '1': {
                return pfx + "One";
            }
            case '2': {
                return pfx + "Two";
            }
            case '3': {
                return pfx + "Three";
            }
            case '4': {
                return pfx + "Four";
            }
            case '5': {
                return pfx + "Five";
            }
            case '6': {
                return pfx + "Six";
            }
            case '7': {
                return pfx + "Seven";
            }
            case '8': {
                return pfx + "Eight";
            }
            case '9': {
                return pfx + "Nine";
            }
            case '.': {
                return pfx + "Dot";
            }
            case '>': {
                return pfx + "GreaterThan";
            }
            case '<': {
                return pfx + "LessThan";
            }
            case '%': {
                return pfx + "Percent";
            }
            case '|': {
                return pfx + "Pipe";
            }
            case '_': {
                return pfx + "Underscore";
            }
            case '$': {
                return pfx + "Dollar";
            }
            case '\\': {
                return pfx + "Backslash";
            }
            case '/': {
                return pfx + "Slash";
            }
            case '`': {
                return pfx + "Backtick";
            }
            case '^': {
                return pfx + "Caren";
            }
            case '@': {
                return pfx + "At";
            }
            case '!': {
                return pfx + "Bang";
            }
            case '#': {
                return pfx + "Pound";
            }
            case '[': {
                return pfx + "LeftBracket";
            }
            case ']': {
                return pfx + "RightBracket";
            }
            case '{': {
                return pfx + "LeftBrace";
            }
            case '}': {
                return pfx + "RightBrace";
            }
        }
        return pfx + this.namify(Character.getName(c));
    }

    private String namify(String name) {
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        block3: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case ' ': 
                case '-': 
                case '_': {
                    capitalize = true;
                    if (!this.delimit) continue block3;
                    sb.append('_');
                    capitalize = true;
                    continue block3;
                }
                default: {
                    c = capitalize ? Character.toUpperCase(c) : Character.toLowerCase(c);
                    sb.append(c);
                    capitalize = false;
                }
            }
        }
        return sb.toString();
    }
}

