/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.Strings;
import com.mastfrog.util.strings.SymbolEscaper;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public interface Escaper {
    public static final Escaper JAVA_IDENTIFIER_DELIMITED = new SymbolEscaper(true);
    public static final Escaper JAVA_IDENTIFIER_CAMEL_CASE = new SymbolEscaper(false);
    public static final Escaper BASIC_HTML = c -> {
        switch (c) {
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\u00a9': {
                return "&copy;";
            }
            case '\u00ae': {
                return "&reg;";
            }
            case '\u2122': {
                return "&trade;";
            }
            case '\u00a2': {
                return "&cent;";
            }
            case '\u00a3': {
                return "&pound;";
            }
            case '\u00a5': {
                return "&yen;";
            }
            case '\u20ac': {
                return "&euro;";
            }
        }
        return null;
    };
    public static final Escaper JAVADOC_CODE_SAMPLE = c -> {
        switch (c) {
            case '@': {
                return "&#064;";
            }
            case '{': {
                return "&#123;";
            }
            case '}': {
                return "&#125;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\u00a9': {
                return "&copy;";
            }
            case '\u00ae': {
                return "&reg;";
            }
            case '\u2122': {
                return "&trade;";
            }
            case '\u00a2': {
                return "&cent;";
            }
            case '\u00a3': {
                return "&pound;";
            }
            case '\u00a5': {
                return "&yen;";
            }
            case '\u20ac': {
                return "&euro;";
            }
        }
        return null;
    };
    public static final Escaper HTML_WITH_LINE_BREAKS = c -> {
        CharSequence result = BASIC_HTML.escape(c);
        if (result == null) {
            switch (c) {
                case '\r': {
                    result = "";
                    break;
                }
                case '\n': {
                    result = "<br>";
                }
            }
        }
        return result;
    };
    public static final Escaper NEWLINES_AND_OTHER_WHITESPACE = c -> {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
            case '\b': {
                return "\\b";
            }
        }
        return null;
    };
    public static final Escaper CONTROL_CHARACTERS = c -> {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    };
    public static final Escaper OMIT_NON_WORD_CHARACTERS = c -> !Character.isDigit(c) && !Character.isLetter(c) ? "" : Character.toString(c);

    public CharSequence escape(char var1);

    default public String escape(CharSequence input) {
        return Strings.escape(input, this);
    }

    default public CharSequence escape(char c, int index, int of, char prev) {
        return this.escape(c);
    }

    public static Escaper escapeUnencodableAndControlCharacters(Charset cs) {
        CharsetEncoder enc = cs.newEncoder();
        return c -> {
            switch (c) {
                case '\t': {
                    return "\\t";
                }
                case '\r': {
                    return "\\r";
                }
                case '\n': {
                    return "\\n";
                }
            }
            if (!enc.canEncode(c) || Character.isISOControl(c)) {
                return "<0x" + Strings.toHex(c) + ">";
            }
            return null;
        };
    }

    default public Escaper ignoring(char c) {
        return c1 -> {
            if (c1 == c) {
                return null;
            }
            return this.escape(c);
        };
    }

    default public Escaper and(final Escaper other) {
        return new Escaper(){

            @Override
            public CharSequence escape(char c) {
                CharSequence result = Escaper.this.escape(c);
                return result == null ? other.escape(c) : result;
            }

            @Override
            public CharSequence escape(char c, int index, int of, char prev) {
                CharSequence result = Escaper.this.escape(c, index, of, prev);
                return result == null ? other.escape(c, index, of, prev) : result;
            }
        };
    }

    default public Escaper escaping(char c) {
        return this.and(c1 -> {
            if (c1 == c) {
                return "\\" + c;
            }
            return null;
        });
    }

    default public Escaper escapeDoubleQuotes() {
        return this.and(c -> {
            if (c == '\"') {
                return "\\\"";
            }
            return null;
        });
    }

    default public Escaper escapeSingleQuotes() {
        return this.and(c -> {
            if (c == '\"') {
                return "\\\"";
            }
            return null;
        });
    }
}

