/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import java.util.function.Supplier;
import java.util.stream.IntStream;

final class LazyCharSequence
implements CharSequence {
    private final Supplier<? extends CharSequence> delegateSupplier;
    private CharSequence delegate;
    private final boolean cache;

    LazyCharSequence(Supplier<? extends CharSequence> delegateSupplier, boolean cache) {
        this.delegateSupplier = delegateSupplier;
        this.cache = cache;
    }

    CharSequence delegate() {
        if (!this.cache) {
            return this.delegateSupplier.get();
        }
        if (this.delegate == null) {
            this.delegate = this.delegateSupplier.get();
            if (this.delegate == null) {
                this.delegate = "";
            }
        }
        return this.delegate;
    }

    @Override
    public int length() {
        return this.delegate().length();
    }

    @Override
    public char charAt(int index) {
        return this.delegate().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new LazyCharSequence(() -> this.delegate.subSequence(start, end), this.cache);
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    @Override
    public IntStream chars() {
        return this.delegate().chars();
    }

    @Override
    public IntStream codePoints() {
        return this.delegate().codePoints();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof CharSequence && ((CharSequence)o).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

