/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class LevenshteinDistance {
    private LevenshteinDistance() {
        throw new AssertionError();
    }

    public static void sortByDistance(String to, List<String> l) {
        LevenshteinDistance.sortByDistance(to, false, l);
    }

    public static void sortByDistance(String to, boolean caseSensitive, List<String> l) {
        Collections.sort(l, new LevenshteinComparator(to, caseSensitive));
    }

    public static <T> void sortByDistance(T to, List<T> items, Function<T, String> stringifier) {
        LevenshteinDistance.sortByDistance(to, false, items, stringifier);
    }

    public static <T> void sortByDistance(T to, boolean caseSensitive, List<T> items, Function<T, String> stringifier) {
        Collections.sort(items, LevenshteinDistance.distanceComparator(to, caseSensitive, stringifier));
    }

    public static Comparator<String> distanceComparator(String to) {
        return LevenshteinDistance.distanceComparator(to, false);
    }

    public static Comparator<String> distanceComparator(String to, boolean caseSensitive) {
        return new LevenshteinComparator(to, caseSensitive);
    }

    public static <T> Comparator<T> distanceComparator(T to, Function<T, String> stringifier) {
        return LevenshteinDistance.distanceComparator(to, false, stringifier);
    }

    public static <T> Comparator<T> distanceComparator(T to, boolean caseSensitive, Function<T, String> stringifier) {
        return new AdaptedLevenshteinComparator<T>(to, caseSensitive, stringifier);
    }

    public static <T> List<T> topMatches(int max, T to, List<T> items, Function<T, String> stringifier) {
        return LevenshteinDistance.topMatches(max, to, false, items, stringifier);
    }

    public static <T> List<T> topMatches(int max, T to, boolean caseSensitive, List<T> items, Function<T, String> stringifier) {
        ArrayList<T> result = new ArrayList<T>(items);
        LevenshteinDistance.sortByDistance(to, caseSensitive, result, stringifier);
        if (result.size() > max) {
            return result.subList(0, max);
        }
        return result;
    }

    public static List<String> topMatches(int max, String to, List<String> items) {
        return LevenshteinDistance.topMatches(max, to, false, items);
    }

    public static List<String> topMatches(int max, String to, boolean caseSensitive, List<String> items) {
        ArrayList<String> result = new ArrayList<String>(items);
        LevenshteinDistance.sortByDistance(to, result);
        if (result.size() > max) {
            return result.subList(0, max);
        }
        return result;
    }

    public static int levenshteinDistance(String a, String b, boolean caseSensitive) {
        int i;
        if (!caseSensitive) {
            a = a.toLowerCase();
            b = b.toLowerCase();
        }
        int[][] distance = new int[a.length() + 1][b.length() + 1];
        for (i = 0; i <= a.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= b.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= a.length(); ++i) {
            for (int j = 1; j <= b.length(); ++j) {
                distance[i][j] = LevenshteinDistance.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[a.length()][b.length()];
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float score(String a, String b, boolean caseSensitive) {
        boolean ea = a.isEmpty();
        boolean eb = b.isEmpty();
        if (ea && eb) {
            return 0.0f;
        }
        if (ea || eb) {
            return 1.0f;
        }
        if (caseSensitive ? a.equals(b) : a.equalsIgnoreCase(b)) {
            return 0.0f;
        }
        float dist = LevenshteinDistance.levenshteinDistance(a, b, caseSensitive);
        float maxLen = Math.max(a.length(), b.length());
        if (dist == 0.0f) {
            return 0.0f;
        }
        float result = dist / maxLen;
        return result;
    }

    public static float inverseScore(String a, String b, boolean caseSensitive) {
        return 1.0f - LevenshteinDistance.score(a, b, caseSensitive);
    }

    private static final class LevenshteinComparator
    implements Comparator<String> {
        private final String to;
        private final boolean caseSensitive;

        LevenshteinComparator(String to, boolean caseSensitive) {
            this.to = to;
            this.caseSensitive = caseSensitive;
        }

        LevenshteinComparator(String to) {
            this(to, false);
        }

        @Override
        public int compare(String a, String b) {
            int da = LevenshteinDistance.levenshteinDistance(this.to, a, this.caseSensitive);
            int db = LevenshteinDistance.levenshteinDistance(this.to, b, this.caseSensitive);
            return Integer.compare(da, db);
        }
    }

    private static final class AdaptedLevenshteinComparator<T>
    implements Comparator<T> {
        private final T orig;
        private final Function<T, String> stringifier;
        private final boolean caseSensitive;
        LevenshteinComparator comparator;

        public AdaptedLevenshteinComparator(T orig, boolean caseSensitive, Function<T, String> stringifier) {
            this.orig = orig;
            this.caseSensitive = caseSensitive;
            this.stringifier = stringifier;
        }

        @Override
        public int compare(T o1, T o2) {
            if (this.comparator == null) {
                this.comparator = new LevenshteinComparator(this.stringifier.apply(this.orig), this.caseSensitive);
            }
            return this.comparator.compare(this.stringifier.apply(o1), this.stringifier.apply(o2));
        }
    }
}

