/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

final class MatchWords
implements Predicate<CharSequence> {
    private final List<MatchState> matchers = new ArrayList<MatchState>();
    private final ThreadLocal<MatchState[]> local = new ThreadLocal();
    private final char[] firsts;
    private final int maxLength;
    private final int minLength;
    private final boolean prefixMatch;
    private final BitSet lengths;

    MatchWords(CharSequence[] strings, boolean prefixMatch) {
        Checks.notNull((String)"strings", (Object)strings);
        if (strings.length == 0) {
            throw new IllegalArgumentException("Zero length array of strings");
        }
        this.prefixMatch = prefixMatch;
        CharSequence[] all = Arrays.copyOf(strings, strings.length);
        char[] firsts = new char[all.length];
        Arrays.sort(all, Strings.charSequenceComparator());
        int max = 0;
        int min = Integer.MAX_VALUE;
        char lastFirst = '\u0000';
        int firstIndex = 0;
        CharSequence prev = null;
        for (int i = 0; i < all.length; ++i) {
            CharSequence curr = all[i];
            if (curr.length() == 0) {
                throw new IllegalArgumentException("Cannot match on the empty string: " + Strings.join(',', strings));
            }
            Checks.notNull((String)("strings[" + i + "]"), (Object)curr);
            if (prefixMatch && prev != null && Strings.startsWith(curr, prev)) {
                throw new IllegalArgumentException("Already added '" + prev + "' which is the prefix of '" + curr + "' - will never match '" + curr + "'");
            }
            this.matchers.add(new MatchState(curr));
            char first = curr.charAt(0);
            if (first != lastFirst) {
                firsts[firstIndex++] = first;
            }
            lastFirst = first;
            max = Math.max(max, curr.length());
            min = Math.min(min, curr.length());
            prev = curr;
        }
        if (firstIndex != all.length) {
            firsts = Arrays.copyOf(firsts, firstIndex);
        }
        if (!prefixMatch) {
            this.lengths = new BitSet(max - 1);
            for (CharSequence s : all) {
                this.lengths.set(s.length());
            }
        } else {
            this.lengths = null;
        }
        Arrays.sort(firsts);
        this.maxLength = max;
        this.minLength = min;
        this.firsts = firsts;
    }

    public static Predicate<CharSequence> matchPrefixes(CharSequence ... sequences) {
        return new MatchWords(sequences, true);
    }

    public static Predicate<CharSequence> matchWords(CharSequence ... sequences) {
        return new MatchWords(sequences, false);
    }

    public static Function<CharSequence, CharSequence> findPrefixes(CharSequence ... prefixen) {
        MatchWords mw = new MatchWords(prefixen, true);
        return mw::find;
    }

    public static Predicate<CharSequence> matchWords(String ... strings) {
        return new MatchWords(strings, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MatchState state : this.matchers) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(state.what);
        }
        sb.insert(0, "MatchWords{").append(';');
        sb.append(" minLength=").append(this.minLength).append(" maxLength=").append(this.maxLength).append(" prefix=").append(this.prefixMatch).append('}');
        return sb.toString();
    }

    private MatchState[] matchers() {
        MatchState[] result = this.local.get();
        if (result == null) {
            result = new MatchState[this.matchers.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.matchers.get(i).copy();
            }
            this.local.set(result);
        }
        return result;
    }

    @Override
    public boolean test(CharSequence t) {
        return this.find(t) != null;
    }

    public CharSequence find(CharSequence t) {
        MatchState[] mtchrs;
        int max = t.length();
        if (max == 0 || max < this.minLength) {
            return null;
        }
        if (max > this.maxLength && !this.prefixMatch) {
            return null;
        }
        if (!this.prefixMatch && !this.lengths.get(max)) {
            return null;
        }
        for (MatchState mtchr : mtchrs = this.matchers()) {
            mtchr.reset();
        }
        int firstMatcher = 0;
        int lastMatcher = mtchrs.length;
        for (int i = 0; i < max; ++i) {
            char c = t.charAt(i);
            if (i == 0) {
                int firstIndex = Arrays.binarySearch(this.firsts, c);
                if (firstIndex < 0) {
                    return null;
                }
                firstMatcher = firstIndex;
            }
            if (firstMatcher == lastMatcher) {
                return null;
            }
            for (int j = firstMatcher; j < lastMatcher; ++j) {
                if (!this.prefixMatch && mtchrs[j].length() != max) {
                    if (j == firstMatcher) {
                        ++firstMatcher;
                        continue;
                    }
                    if (j != lastMatcher - 1) continue;
                    --lastMatcher;
                    continue;
                }
                mtchrs[j].check(c);
                if (mtchrs[j].isMatched()) {
                    return mtchrs[j].what;
                }
                if (j == firstMatcher && mtchrs[j].isFailed()) {
                    ++firstMatcher;
                    continue;
                }
                if (j != lastMatcher - 1 - 1 || !mtchrs[j].isFailed()) continue;
                --lastMatcher;
            }
        }
        return null;
    }

    private static final class MatchState
    implements Comparable<MatchState> {
        private final CharSequence what;
        private int matched = 0;
        private boolean failed = false;
        private final int length;

        MatchState(CharSequence what) {
            this.what = what;
            this.length = what.length();
        }

        MatchState(char[] what) {
            this.what = new String(what);
            this.length = what.length;
        }

        public MatchState copy() {
            return new MatchState(this.what);
        }

        private void reset() {
            this.matched = 0;
            this.failed = false;
        }

        public String toString() {
            return this.what.toString();
        }

        boolean isFailed() {
            return this.failed;
        }

        int length() {
            return this.length;
        }

        boolean isMatched() {
            return this.matched >= this.length;
        }

        void check(char c) {
            if (this.failed || this.isMatched()) {
                return;
            }
            if (this.what.charAt(this.matched) == c) {
                ++this.matched;
            } else {
                this.failed = true;
            }
        }

        @Override
        public int compareTo(MatchState o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

