/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.Strings;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class RandomStrings {
    private final Random random;
    private static final char[] ALPHANUM = "ABCDEFGHIJKLMNOPQRSTUVWXYZ-abcdefghijklmnopqrstuvwxyz01234567890._".toCharArray();
    private static final AtomicLong COUNTER = new AtomicLong(Long.MIN_VALUE);

    public RandomStrings(SecureRandom sec) {
        this(new Random(sec.nextLong()));
    }

    public RandomStrings(Random random) {
        this.random = random;
    }

    public RandomStrings() {
        this(new Random(System.currentTimeMillis()));
    }

    public String get() {
        return this.get(24);
    }

    public String randomChars(int count) {
        char[] result = new char[count];
        char[] an = Arrays.copyOf(ALPHANUM, ALPHANUM.length);
        Strings.shuffle(this.random, an);
        if (result.length <= an.length) {
            System.arraycopy(an, 0, result, 0, result.length);
        } else {
            System.arraycopy(an, 0, result, 0, an.length);
            for (int i = an.length; i < result.length; ++i) {
                result[i] = ALPHANUM[this.random.nextInt(ALPHANUM.length)];
            }
        }
        return new String(result);
    }

    public String guidLike(int segments, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < segments; ++i) {
            if (sb.length() != 0) {
                sb.append('-');
            }
            sb.append(this.randomChars(length));
        }
        return sb.toString();
    }

    public String get(int length) {
        byte[] bytes = new byte[length];
        this.random.nextBytes(bytes);
        if (length > 8) {
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(COUNTER.getAndIncrement());
        }
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)ALPHANUM[Math.abs(bytes[i] % ALPHANUM.length)];
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static void main(String[] args) {
        RandomStrings rs = new RandomStrings();
        for (int i = 0; i < 10; ++i) {
            System.out.println(rs.get());
        }
    }
}

