/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.ComparableCharSequence;
import com.mastfrog.util.strings.Strings;

final class SingleCharSequence
implements CharSequence,
ComparableCharSequence {
    private final char c;

    SingleCharSequence(char c) {
        this.c = c;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public char charAt(int index) {
        if (index == 0) {
            return this.c;
        }
        throw new StringIndexOutOfBoundsException(index + " of 1");
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == 0) {
            return Strings.emptyCharSequence();
        }
        if (start == 0 && end == 1) {
            return this;
        }
        throw new StringIndexOutOfBoundsException("Length is 1 but requested subsequence " + start + " to " + end);
    }

    public int hashCode() {
        return this.c;
    }

    public boolean equals(Object o) {
        return o == null ? false : (o == this ? true : (o instanceof CharSequence && ((CharSequence)o).length() == 1 ? ((CharSequence)o).charAt(0) == this.c : false));
    }

    @Override
    public String toString() {
        return Character.toString(this.c);
    }

    @Override
    public int compareTo(CharSequence o) {
        if (o.length() == 0) {
            return 1;
        }
        char first = o.charAt(0);
        return first > this.c ? -1 : (first == this.c ? 0 : -1);
    }

    @Override
    public boolean startsWith(CharSequence seq) {
        return seq.length() == 1 && seq.charAt(0) == this.c;
    }

    @Override
    public int indexOf(char c) {
        return c == this.c ? 0 : -1;
    }

    @Override
    public int lastIndexOf(char c) {
        return this.indexOf(c);
    }
}

