/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class UniqueIDs {
    private final AtomicInteger seq;
    private final Random random;
    private final byte[] base;
    private final int vmid;
    private final byte[] networkSignature;
    static UniqueIDs INSTANCE;
    private static final char[] ALPHA;
    private String reversed;

    public UniqueIDs() throws IOException {
        this(Paths.get(System.getProperty("java.io.tmpdir"), UniqueIDs.class.getName() + "-" + System.currentTimeMillis() + ".uid"));
        System.err.println("Using " + UniqueIDs.class.getName() + " without passing a file.  Not recommended for production use.");
    }

    @Deprecated
    public static UniqueIDs createNoFile() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new UniqueIDs((File)null);
            return INSTANCE;
        }
        return INSTANCE;
    }

    public static UniqueIDs noFile() {
        try {
            return UniqueIDs.createNoFile();
        }
        catch (IOException ex) {
            return (UniqueIDs)Exceptions.chuck((Throwable)ex);
        }
    }

    public UniqueIDs(Path path) throws IOException {
        this(path.toFile());
    }

    public UniqueIDs(File appfile) throws IOException {
        SecureRandom sr = new SecureRandom();
        int ts = (int)(System.currentTimeMillis() - 1483853019824L + (long)sr.nextInt(720000));
        this.seq = new AtomicInteger(ts);
        this.random = new Random(sr.nextLong());
        this.vmid = Math.abs(sr.nextInt());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.networkSignature = UniqueIDs.networkInterfaceSignature();
        byte[] addrBytes = this.networkSignature;
        if (appfile != null && appfile.exists()) {
            byte[] b = new byte[5];
            byte[] all = Files.readAllBytes(appfile.toPath());
            if (all.length == 5) {
                b = all;
            } else {
                System.arraycopy(all, 0, b, 0, 5);
            }
            baos.write(b);
        } else {
            byte[] bts = new byte[5];
            this.random.nextBytes(bts);
            if (appfile != null) {
                appfile.createNewFile();
                try (FileOutputStream out = new FileOutputStream(appfile);){
                    out.write(bts);
                }
            }
            baos.write(bts);
        }
        baos.write(this.intToBytes(this.vmid));
        baos.write(addrBytes);
        this.base = baos.toByteArray();
    }

    static byte[] networkInterfaceSignature() throws SocketException {
        byte[] addrBytes = new byte[6];
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en != null && en.hasMoreElements()) {
            byte[] macAddress;
            NetworkInterface i = en.nextElement();
            if (i == null || i.isLoopback() || i.isVirtual() || (macAddress = i.getHardwareAddress()) == null) continue;
            UniqueIDs.xor(macAddress, addrBytes);
        }
        return addrBytes;
    }

    public String uniqueToVmString() {
        ByteBuffer buf = ByteBuffer.allocate(18);
        buf.putInt(this.seq.getAndIncrement());
        buf.put(this.networkSignature);
        buf.putLong(System.currentTimeMillis());
        return Base64.getEncoder().encodeToString(buf.array());
    }

    private static void xor(byte[] src, byte[] dest) {
        if (src != null && dest != null) {
            for (int i = 0; i < Math.min(src.length, dest.length); ++i) {
                int n = i;
                dest[n] = (byte)(dest[n] ^ src[i]);
            }
        }
    }

    private String bytesToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(36);
        for (int i = 0; i < bytes.length - bytes.length % 3; i += 3) {
            int value1 = bytes[i] >> 2;
            int value2 = (bytes[i] & 3) << 4 | bytes[i + 1] >> 4;
            int value3 = (bytes[i + 1] & 0xF) << 2 | bytes[i + 2] >> 6;
            int value4 = bytes[i + 2] & 0x3F;
            sb.append(ALPHA[Math.abs(value1)]).append(ALPHA[Math.abs(value2)]).append(ALPHA[Math.abs(value3)]).append(ALPHA[Math.abs(value4)]);
        }
        return sb.toString();
    }

    private byte[] intToBytes(int x) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(x);
        return buffer.array();
    }

    public String newId() {
        int inc = this.random.nextInt(13) + 1;
        int ix = this.seq.addAndGet(inc);
        int size = 12 + this.base.length;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(this.reverse(this.intToBytes(ix))).putLong(this.random.nextLong()).put(this.base);
        return this.bytesToString(buf.array());
    }

    private byte[] reverse(byte[] b) {
        for (int i = 0; i < b.length / 2; ++i) {
            byte hold = b[i];
            b[i] = b[b.length - (i + 1)];
            b[b.length - (i + 1)] = hold;
        }
        return b;
    }

    public String toString() {
        return this.bytesToString(this.base);
    }

    public String newRandomString() {
        return this.newRandomString(16);
    }

    public String newRandomString(int count) {
        byte[] bytes = new byte[count];
        this.random.nextBytes(bytes);
        return this.bytesToString(bytes);
    }

    public boolean recognizes(String id) {
        Checks.notNull((String)"id", (Object)id);
        if (this.reversed == null) {
            this.reversed = this.bytesToString(this.base);
        }
        return id.endsWith(this.reversed);
    }

    public boolean knows(String id) {
        Checks.notNull((String)"id", (Object)id);
        if (this.reversed == null) {
            this.reversed = this.bytesToString(this.base);
        }
        return id.endsWith(this.reversed.substring(this.reversed.length() - 8, this.reversed.length()));
    }

    public static void main(String[] args) throws IOException {
        UniqueIDs ids = new UniqueIDs(new File("/tmp/foo.bytes"));
        for (int i = 0; i < 100; ++i) {
            String id = ids.newId();
            System.out.println(id);
            System.out.println(ids.uniqueToVmString());
        }
    }

    static {
        ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz0123456789~".toCharArray();
    }
}

