/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.config;

import com.mattbertolini.spring.web.bind.AbstractPropertyResolverRegistry;
import com.mattbertolini.spring.web.bind.introspect.AnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.bind.introspect.ClassPathScanningAnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.bind.introspect.DefaultAnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.servlet.mvc.bind.BeanParameterMethodArgumentResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.PropertyResolverRegistry;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.CookieParameterRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.FormParameterMapRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.FormParameterRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.HeaderParameterMapRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.HeaderParameterRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.PathParameterMapRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.PathParameterRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestBodyRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestContextRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestParameterMapRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestParameterRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.SessionParameterRequestPropertyResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class BinderConfiguration
implements BeanPostProcessor {
    private final Set<String> packagesToScan = new LinkedHashSet<String>();
    private final PropertyResolverRegistry propertyResolverRegistry;

    public BinderConfiguration() {
        this(new PropertyResolverRegistry());
    }

    public BinderConfiguration(PropertyResolverRegistry propertyResolverRegistry) {
        this.propertyResolverRegistry = propertyResolverRegistry;
    }

    public BinderConfiguration addPackageToScan(String packageToScan) {
        this.packagesToScan.add(packageToScan);
        return this;
    }

    public BinderConfiguration setPackagesToScan(Set<String> packagesToScan) {
        this.packagesToScan.addAll(packagesToScan);
        return this;
    }

    public BinderConfiguration addResolver(RequestPropertyResolver resolver) {
        this.propertyResolverRegistry.addResolver(resolver);
        return this;
    }

    public BinderConfiguration addResolvers(Set<RequestPropertyResolver> resolvers) {
        this.propertyResolverRegistry.addResolvers(resolvers);
        return this;
    }

    public BinderConfiguration addResolvers(PropertyResolverRegistry propertyResolverRegistry) {
        this.propertyResolverRegistry.addResolvers(propertyResolverRegistry);
        return this;
    }

    public Set<String> getPackagesToScan() {
        return Collections.unmodifiableSet(this.packagesToScan);
    }

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) {
        if (!(bean instanceof RequestMappingHandlerAdapter)) {
            return bean;
        }
        RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)bean;
        PropertyResolverRegistry resolverRegistry = this.createPropertyResolverRegistry(adapter);
        AnnotatedRequestBeanIntrospector introspector = this.createIntrospector(resolverRegistry);
        BeanParameterMethodArgumentResolver resolver = this.createResolver(introspector);
        this.addCustomResolverToHandlerAdapter(adapter, resolver);
        return adapter;
    }

    private PropertyResolverRegistry createPropertyResolverRegistry(RequestMappingHandlerAdapter adapter) {
        PropertyResolverRegistry registry = new PropertyResolverRegistry();
        registry.addResolver(new RequestParameterRequestPropertyResolver());
        registry.addResolver(new RequestParameterMapRequestPropertyResolver());
        registry.addResolver(new FormParameterRequestPropertyResolver());
        registry.addResolver(new FormParameterMapRequestPropertyResolver());
        registry.addResolver(new PathParameterRequestPropertyResolver());
        registry.addResolver(new PathParameterMapRequestPropertyResolver());
        registry.addResolver(new CookieParameterRequestPropertyResolver());
        registry.addResolver(new HeaderParameterRequestPropertyResolver());
        registry.addResolver(new HeaderParameterMapRequestPropertyResolver());
        registry.addResolver(new SessionParameterRequestPropertyResolver());
        registry.addResolver(new RequestContextRequestPropertyResolver());
        registry.addResolver(new RequestBodyRequestPropertyResolver(adapter.getMessageConverters()));
        registry.addResolvers(this.propertyResolverRegistry);
        return registry;
    }

    private AnnotatedRequestBeanIntrospector createIntrospector(PropertyResolverRegistry registry) {
        DefaultAnnotatedRequestBeanIntrospector defaultIntrospector = new DefaultAnnotatedRequestBeanIntrospector((AbstractPropertyResolverRegistry)registry);
        ClassPathScanningAnnotatedRequestBeanIntrospector introspector = new ClassPathScanningAnnotatedRequestBeanIntrospector((AnnotatedRequestBeanIntrospector)defaultIntrospector, this.packagesToScan);
        try {
            introspector.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new BeanInitializationException("Unable to create introspector", (Throwable)e);
        }
        return introspector;
    }

    private BeanParameterMethodArgumentResolver createResolver(AnnotatedRequestBeanIntrospector introspector) {
        return new BeanParameterMethodArgumentResolver(introspector);
    }

    private void addCustomResolverToHandlerAdapter(RequestMappingHandlerAdapter adapter, BeanParameterMethodArgumentResolver resolver) {
        List currentResolvers = adapter.getCustomArgumentResolvers();
        if (currentResolvers == null) {
            currentResolvers = Collections.emptyList();
        }
        ArrayList<Object> newResolvers = new ArrayList<Object>(currentResolvers.size() + 1);
        newResolvers.addAll(currentResolvers);
        newResolvers.add((Object)resolver);
        adapter.setCustomArgumentResolvers(newResolvers);
    }
}

