/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.CookieParameter;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.WebUtils;

public class CookieParameterRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull BindingProperty bindingProperty) {
        return bindingProperty.hasAnnotation(CookieParameter.class);
    }

    public Object resolve(@NonNull BindingProperty bindingProperty, @NonNull NativeWebRequest request) {
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"A HttpServletRequest is required for this resolver and none found.");
        CookieParameter annotation = (CookieParameter)bindingProperty.getAnnotation(CookieParameter.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"No CookieParameter annotation found on type");
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)annotation.value());
        if (cookie == null) {
            return null;
        }
        if (Cookie.class == bindingProperty.getObjectType()) {
            return cookie;
        }
        return cookie.getValue();
    }
}

