/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.HeaderParameter;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class HeaderParameterMapRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull BindingProperty bindingProperty) {
        HeaderParameter annotation = (HeaderParameter)bindingProperty.getAnnotation(HeaderParameter.class);
        return annotation != null && !StringUtils.hasText((String)annotation.value()) && Map.class.isAssignableFrom(bindingProperty.getType());
    }

    public Object resolve(@NonNull BindingProperty bindingProperty, @NonNull NativeWebRequest request) {
        if (MultiValueMap.class.isAssignableFrom(bindingProperty.getType())) {
            Object retMap = HttpHeaders.class.isAssignableFrom(bindingProperty.getType()) ? new HttpHeaders() : new LinkedMultiValueMap();
            Iterator iterator = request.getHeaderNames();
            while (iterator.hasNext()) {
                String headerName = (String)iterator.next();
                String[] headerValues = request.getHeaderValues(headerName);
                if (headerValues == null) continue;
                for (String headerValue : headerValues) {
                    retMap.add((Object)headerName, (Object)headerValue);
                }
            }
            return retMap;
        }
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        Iterator iterator = request.getHeaderNames();
        while (iterator.hasNext()) {
            String headerName = (String)iterator.next();
            String headerValue = request.getHeader(headerName);
            retMap.put(headerName, headerValue);
        }
        return retMap;
    }
}

