/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.PropertyResolutionException;
import com.mattbertolini.spring.web.bind.annotation.RequestBody;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.List;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class RequestBodyRequestPropertyResolver
implements RequestPropertyResolver {
    private final RequestResponseBodyMethodProcessor processor;

    public RequestBodyRequestPropertyResolver(List<HttpMessageConverter<?>> messageConverters) {
        this(new RequestResponseBodyMethodProcessor(messageConverters));
    }

    RequestBodyRequestPropertyResolver(@NonNull RequestResponseBodyMethodProcessor processor) {
        this.processor = processor;
    }

    public boolean supports(@NonNull BindingProperty bindingProperty) {
        return bindingProperty.hasAnnotation(RequestBody.class);
    }

    public Object resolve(@NonNull BindingProperty bindingProperty, @NonNull NativeWebRequest request) {
        RequestBody annotation = (RequestBody)bindingProperty.getAnnotation(RequestBody.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"No RequestBody annotation found on type");
        try {
            return this.processor.resolveArgument(bindingProperty.getMethodParameter(), null, request, null);
        }
        catch (Exception e) {
            throw new PropertyResolutionException("Error resolving request body.", (Throwable)e);
        }
    }
}

