/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.RequestParameter;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class RequestParameterMapRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull BindingProperty bindingProperty) {
        RequestParameter annotation = (RequestParameter)bindingProperty.getAnnotation(RequestParameter.class);
        return annotation != null && !StringUtils.hasText((String)annotation.value()) && Map.class.isAssignableFrom(bindingProperty.getType());
    }

    public Object resolve(@NonNull BindingProperty bindingProperty, @NonNull NativeWebRequest request) {
        Map parameterMap = request.getParameterMap();
        if (MultiValueMap.class.isAssignableFrom(bindingProperty.getType())) {
            LinkedMultiValueMap ret = new LinkedMultiValueMap(parameterMap.size());
            for (Map.Entry entry : parameterMap.entrySet()) {
                ret.put(entry.getKey(), new LinkedList<Object>(Arrays.asList((Object[])entry.getValue())));
            }
            return ret;
        }
        LinkedHashMap ret = new LinkedHashMap(parameterMap.size());
        for (Map.Entry entry : parameterMap.entrySet()) {
            ret.put(entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return ret;
    }
}

