/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.RequestParameter;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.bind.resolver.AbstractNamedRequestPropertyResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class RequestParameterRequestPropertyResolver
extends AbstractNamedRequestPropertyResolver<NativeWebRequest, Object>
implements RequestPropertyResolver {
    public boolean supports(@NonNull BindingProperty bindingProperty) {
        RequestParameter annotation = (RequestParameter)bindingProperty.getAnnotation(RequestParameter.class);
        return annotation != null && StringUtils.hasText((String)annotation.value());
    }

    protected Object resolveWithName(@NonNull BindingProperty bindingProperty, String name, @NonNull NativeWebRequest request) {
        return request.getParameterValues(name);
    }

    @NonNull
    protected String getName(@NonNull BindingProperty bindingProperty) {
        RequestParameter annotation = (RequestParameter)bindingProperty.getAnnotation(RequestParameter.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"No RequestParameter annotation found on type");
        return annotation.value();
    }
}

