/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.logging;

import com.maxxton.microdocs.core.logging.LogLevel;

public class Logger {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private static Logger reporter = new Logger();
    private LogLevel level = LogLevel.WARNING;

    public static void set(Logger reporter) {
        Logger.reporter = reporter;
    }

    public static Logger get() {
        return reporter;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public void error(String msg) {
        if (this.level.match(LogLevel.ERROR)) {
            System.err.println("\u001b[31m[error] \u001b[0m" + msg);
        }
    }

    public void error(String msg, Throwable e) {
        if (this.level.match(LogLevel.ERROR)) {
            System.err.println("\u001b[31m[error] \u001b[0m" + msg);
            e.printStackTrace();
        }
    }

    public void debug(String msg) {
        if (this.level.match(LogLevel.DEBUG)) {
            System.err.println("\u001b[36m[debug] \u001b[0m" + msg);
        }
    }

    public void info(String msg) {
        if (this.level.match(LogLevel.INFO)) {
            System.out.println(ANSI_GREEN + msg + ANSI_RESET);
        }
    }

    public void warning(String msg) {
        if (this.level.match(LogLevel.WARNING)) {
            System.out.println("\u001b[33m[warning] \u001b[0m" + msg);
        }
    }

    public void logEndpoint(String method, String path) {
        if (this.level.match(LogLevel.INFO)) {
            StringBuilder methodBuilder = new StringBuilder("[" + method + "]");
            while (methodBuilder.length() < 8) {
                methodBuilder.append(" ");
            }
            method = methodBuilder.toString();
            System.out.println(ANSI_BLUE + method + " " + path + ANSI_RESET);
        }
    }
}

