/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.reflect;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.maxxton.microdocs.core.reflect.ClassType;
import com.maxxton.microdocs.core.reflect.ReflectAnnotation;
import com.maxxton.microdocs.core.reflect.ReflectDoc;
import com.maxxton.microdocs.core.reflect.ReflectField;
import com.maxxton.microdocs.core.reflect.ReflectGenericClass;
import com.maxxton.microdocs.core.reflect.ReflectMethod;
import java.util.ArrayList;
import java.util.List;

public class ReflectClass<T>
extends ReflectDoc {
    private String packageName;
    private ClassType type = ClassType.CLASS;
    private String file;
    private boolean isAbstract;
    private ReflectGenericClass superClass;
    private List<ReflectGenericClass> interfaces = new ArrayList<ReflectGenericClass>();
    private List<ReflectAnnotation> annotations = new ArrayList<ReflectAnnotation>();
    private List<ReflectField> declaredFields = new ArrayList<ReflectField>();
    private List<ReflectField> classFields = new ArrayList<ReflectField>();
    private List<ReflectField> enumFields = new ArrayList<ReflectField>();
    private List<ReflectMethod> declaredMethods = new ArrayList<ReflectMethod>();
    private List<ReflectMethod> classMethods = new ArrayList<ReflectMethod>();
    @JsonIgnore
    private T original;

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public ClassType getType() {
        return this.type;
    }

    public void setType(ClassType type) {
        this.type = type;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public ReflectGenericClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(ReflectGenericClass superClass) {
        this.superClass = superClass;
    }

    public List<ReflectGenericClass> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<ReflectGenericClass> interfaces) {
        this.interfaces = interfaces;
    }

    public List<ReflectAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<ReflectAnnotation> annotations) {
        this.annotations = annotations;
    }

    public List<ReflectField> getDeclaredFields() {
        return this.declaredFields;
    }

    public void setDeclaredFields(List<ReflectField> declaredFields) {
        this.declaredFields = declaredFields;
    }

    public List<ReflectField> getClassFields() {
        return this.classFields;
    }

    public void setClassFields(List<ReflectField> classFields) {
        this.classFields = classFields;
    }

    public List<ReflectField> getEnumFields() {
        return this.enumFields;
    }

    public void setEnumFields(List<ReflectField> enumFields) {
        this.enumFields = enumFields;
    }

    public List<ReflectMethod> getDeclaredMethods() {
        return this.declaredMethods;
    }

    public void setDeclaredMethods(List<ReflectMethod> declaredMethods) {
        this.declaredMethods = declaredMethods;
    }

    public List<ReflectMethod> getClassMethods() {
        return this.classMethods;
    }

    public void setClassMethods(List<ReflectMethod> classMethods) {
        this.classMethods = classMethods;
    }

    public T getOriginal() {
        return this.original;
    }

    public void setOriginal(T original) {
        this.original = original;
    }

    public boolean hasAnnotation(String ... names) {
        for (String name : names) {
            if (!this.annotations.stream().anyMatch(annotation -> annotation.getName().equals(name) || annotation.getSimpleName().equals(name))) continue;
            return true;
        }
        return false;
    }

    public boolean hasParent(String ... classNames) {
        for (String className : classNames) {
            if (!this.getName().equals(className) && !className.equals(this.getSimpleName())) continue;
            return true;
        }
        if (this.superClass == null && this.interfaces.isEmpty()) {
            try {
                Class<?>[] interfaceClazzes;
                Class<?> clazz = Class.forName(this.getName());
                Class<?> superClazz = clazz.getSuperclass();
                if (superClazz != null) {
                    this.superClass = this.loadJavaClass(superClazz);
                }
                if ((interfaceClazzes = clazz.getInterfaces()) != null) {
                    for (Class<?> interfaceClazz : interfaceClazzes) {
                        this.interfaces.add(this.loadJavaClass(interfaceClazz));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.superClass != null && this.superClass.getClassType() != null && this.superClass.getClassType().hasParent(classNames)) {
            return true;
        }
        for (ReflectGenericClass genericInterface : this.interfaces) {
            if (genericInterface.getClassType() == null || !genericInterface.getClassType().hasParent(classNames)) continue;
            return true;
        }
        return false;
    }

    private <K> ReflectGenericClass loadJavaClass(Class<K> clazz) {
        ReflectClass<T> reflectClass = new ReflectClass<T>();
        reflectClass.setSimpleName(clazz.getSimpleName());
        reflectClass.setName(clazz.getName());
        ReflectGenericClass reflectGenericClass = new ReflectGenericClass();
        reflectGenericClass.setClassType(reflectClass);
        return reflectGenericClass;
    }

    public ReflectAnnotation getAnnotation(String name) {
        for (ReflectAnnotation annotation : this.annotations) {
            if (!annotation.getName().equals(name) && !annotation.getSimpleName().equals(name)) continue;
            return annotation;
        }
        return null;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String toString() {
        return "ReflectClass{name='" + this.getName() + "', type=" + this.type + ", file='" + this.file + "'}";
    }
}

