/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.reflect;

public class ReflectDescriptionTag {
    private String tagName;
    private String keyword;
    private String description;

    public ReflectDescriptionTag(String tagName, String keyword, String description) {
        this.setTagName(tagName);
        this.setKeyword(keyword);
        this.setDescription(description);
    }

    public ReflectDescriptionTag(String tagName, String text) {
        this.setTagName(tagName);
        this.setKeyword(null);
        this.setDescription(text);
    }

    public ReflectDescriptionTag(String text) {
        this.setText(text);
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        if (tagName != null && (tagName = tagName.toLowerCase()).startsWith("@")) {
            tagName = tagName.substring(1);
        }
        this.tagName = tagName;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContent() {
        Object content = "";
        if (this.getKeyword() != null) {
            content = (String)content + this.getKeyword();
        }
        if (this.getDescription() != null) {
            content = (String)content + " " + this.getDescription();
        }
        return ((String)content).trim();
    }

    public void getText() {
        String text = "@" + this.tagName;
        if (this.keyword != null) {
            text = text + this.keyword;
        }
        if (this.description != null) {
            text = text + this.description;
        }
    }

    public void setText(String text) {
        String[] split = text.split(" ");
        this.setTagName(split[0]);
        if (split.length > 1) {
            this.setKeyword(split[1]);
        } else {
            this.setKeyword(null);
        }
        if (split.length > 2) {
            Object desc = split[2];
            for (int i = 3; i < split.length; ++i) {
                desc = (String)desc + " " + split[i];
            }
            this.setDescription((String)desc);
        } else {
            this.setDescription(null);
        }
    }
}

