/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.mayabot.blas.BaseMatrix;
import com.mayabot.blas.ByteBufferVector;
import com.mayabot.blas.FloatMatrix;
import com.mayabot.blas.MutableFloatArrayMatrix;
import com.mayabot.blas.MutableFloatMatrix;
import com.mayabot.blas.Vector;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0096\u0002J\u0019\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0096\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/mayabot/blas/AreaByteBufferMatrix;", "Lcom/mayabot/blas/BaseMatrix;", "Lcom/mayabot/blas/FloatMatrix;", "rows", "", "cols", "data", "", "Ljava/nio/ByteBuffer;", "(IILjava/util/List;)V", "areaRows", "getAreaRows", "()I", "getData", "()Ljava/util/List;", "get", "Lcom/mayabot/blas/Vector;", "row", "", "i", "j", "index", "toMutableFloatMatrix", "Lcom/mayabot/blas/MutableFloatMatrix;", "write", "", "channel", "Ljava/nio/channels/FileChannel;", "maya-simple-blas"})
public final class AreaByteBufferMatrix
extends BaseMatrix
implements FloatMatrix {
    private final int areaRows;
    @NotNull
    private final List<ByteBuffer> data;

    public final int getAreaRows() {
        return this.areaRows;
    }

    private final int index(int i, int j) {
        return i * this.getCols() + j;
    }

    @Override
    @NotNull
    public Vector get(int row) {
        int area = row / this.areaRows;
        int areaOffeet = row % this.areaRows;
        return new ByteBufferVector(this.data.get(area), areaOffeet * this.getCols(), this.getCols());
    }

    @Override
    public float get(int i, int j) {
        int area = i / this.areaRows;
        int areaOffeet = i % this.areaRows;
        return this.data.get(area).getFloat(this.index(areaOffeet, j) << 2);
    }

    @Override
    public void write(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        for (ByteBuffer x : this.data) {
            x.position(0);
            x.limit(x.capacity());
            channel.write(x);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableFloatMatrix toMutableFloatMatrix() {
        MutableFloatArrayMatrix inputMatrix = new MutableFloatArrayMatrix(this.getRows(), this.getCols());
        int n = 0;
        int n2 = this.getRows();
        while (n < n2) {
            void i;
            inputMatrix.get((int)i).plusAssign(this.get((int)i));
            ++i;
        }
        return inputMatrix;
    }

    @NotNull
    public final List<ByteBuffer> getData() {
        return this.data;
    }

    public AreaByteBufferMatrix(int rows, int cols, @NotNull List<? extends ByteBuffer> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        super(rows, cols);
        this.data = data;
        this.areaRows = this.data.get(0).capacity() / 4 / cols;
    }
}

