/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.mayabot.blas.ByteUtils;
import com.mayabot.blas.FloatArrayMatrix;
import com.mayabot.blas.FloatMatrix;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0006\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0019\u0010\u001d\u001a\u00020\u001a2\u000e\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J)\u0010\u001d\u001a\u00020\u001a2\u000e\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0096\u0001J\b\u0010#\u001a\u00020!H\u0016J\u0011\u0010$\u001a\n \u001f*\u0004\u0018\u00010%0%H\u0096\u0001J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020)H\u0096\u0001J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020+J\b\u0010,\u001a\u00020%H\u0016J\t\u0010-\u001a\u00020!H\u0096\u0001J\t\u0010.\u001a\u00020!H\u0096\u0001J\u0011\u0010/\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020!H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/mayabot/blas/AutoDataInput;", "Ljava/io/DataInput;", "dataInput", "order", "Ljava/nio/ByteOrder;", "(Ljava/io/DataInput;Ljava/nio/ByteOrder;)V", "getDataInput", "()Ljava/io/DataInput;", "getOrder", "()Ljava/nio/ByteOrder;", "readBuffer", "", "utf", "loadFloatMatrix", "Lcom/mayabot/blas/FloatMatrix;", "readBoolean", "", "readByte", "", "readChar", "", "readDouble", "", "readFloat", "", "readFloatArray", "", "target", "", "readFully", "p0", "kotlin.jvm.PlatformType", "p1", "", "p2", "readInt", "readLine", "", "readLong", "", "readShort", "", "readShortArray", "", "readUTF", "readUnsignedByte", "readUnsignedShort", "skipBytes", "Companion", "maya-simple-blas"})
public final class AutoDataInput
implements DataInput {
    private byte[] utf;
    private final byte[] readBuffer;
    @NotNull
    private final DataInput dataInput;
    @NotNull
    private final ByteOrder order;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void readShortArray(@NotNull short[] target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        int n = 0;
        int n2 = target.length;
        while (n < n2) {
            void i;
            byte b = this.readByte();
            target[i] = ByteUtils.byte2UInt(b);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void readFloatArray(@NotNull float[] target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        int n = 0;
        int n2 = target.length;
        while (n < n2) {
            void i;
            target[i] = this.readFloat();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FloatMatrix loadFloatMatrix() {
        int rows = (int)this.readLong();
        int cols = (int)this.readLong();
        int length = rows * cols;
        float[] matrix = new float[length];
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            matrix[i] = this.readFloat();
            ++i;
        }
        return new FloatArrayMatrix(rows, cols, matrix);
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        String string;
        int i = 0;
        int len = this.utf.length;
        byte b = this.readByte();
        while (b != 0) {
            this.utf[i++] = b;
            if (i == len) {
                Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(this.utf, this.utf.length * 2), (String)"Arrays.copyOf(utf, utf.size * 2)");
                this.utf = this.utf;
                len = this.utf.length;
            }
            b = this.readByte();
        }
        if (i > 0) {
            byte[] byArray = this.utf;
            int n = 0;
            string = new String(byArray, n, i, Charsets.UTF_8);
        } else {
            string = "";
        }
        return string;
    }

    @Override
    public int readInt() {
        int n;
        if (Intrinsics.areEqual((Object)this.order, (Object)ByteOrder.LITTLE_ENDIAN)) {
            int ch4 = this.dataInput.readUnsignedByte();
            int ch3 = this.dataInput.readUnsignedByte();
            int ch2 = this.dataInput.readUnsignedByte();
            int ch1 = this.dataInput.readUnsignedByte();
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                throw (Throwable)new EOFException();
            }
            n = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        } else {
            n = this.dataInput.readInt();
        }
        return n;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public long readLong() throws IOException {
        long l;
        if (Intrinsics.areEqual((Object)this.order, (Object)ByteOrder.LITTLE_ENDIAN)) {
            this.readFully(this.readBuffer, 0, 8);
            l = ByteUtils.readLITTLELong(this.readBuffer);
        } else {
            l = this.dataInput.readLong();
        }
        return l;
    }

    @NotNull
    public final DataInput getDataInput() {
        return this.dataInput;
    }

    @NotNull
    public final ByteOrder getOrder() {
        return this.order;
    }

    public AutoDataInput(@NotNull DataInput dataInput, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)dataInput, (String)"dataInput");
        Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
        this.dataInput = dataInput;
        this.order = order;
        this.utf = new byte[256];
        this.readBuffer = new byte[8];
    }

    public /* synthetic */ AutoDataInput(DataInput dataInput, ByteOrder byteOrder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.BIG_ENDIAN");
            byteOrder = byteOrder2;
        }
        this(dataInput, byteOrder);
    }

    @Override
    public boolean readBoolean() {
        return this.dataInput.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.dataInput.readByte();
    }

    @Override
    public char readChar() {
        return this.dataInput.readChar();
    }

    @Override
    public void readFully(byte[] p0) {
        this.dataInput.readFully(p0);
    }

    @Override
    public void readFully(byte[] p0, int p1, int p2) {
        this.dataInput.readFully(p0, p1, p2);
    }

    @Override
    public String readLine() {
        return this.dataInput.readLine();
    }

    @Override
    public short readShort() {
        return this.dataInput.readShort();
    }

    @Override
    public int readUnsignedByte() {
        return this.dataInput.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() {
        return this.dataInput.readUnsignedShort();
    }

    @Override
    public int skipBytes(int p0) {
        return this.dataInput.skipBytes(p0);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mayabot/blas/AutoDataInput$Companion;", "", "()V", "open", "Lcom/mayabot/blas/AutoDataInput;", "file", "Ljava/io/File;", "maya-simple-blas"})
    public static final class Companion {
        @NotNull
        public final AutoDataInput open(@NotNull File file) {
            AutoDataInput autoDataInput;
            DataInputStream dataInputStream;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Object object = file;
            DataInputStream dataInputStream2 = dataInputStream;
            DataInputStream dataInputStream3 = dataInputStream;
            AutoDataInput autoDataInput2 = autoDataInput;
            AutoDataInput autoDataInput3 = autoDataInput;
            InputStream inputStream = new FileInputStream((File)object);
            object = inputStream;
            int n = 8192;
            inputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            dataInputStream2(inputStream);
            autoDataInput2(dataInputStream3, null, 2, null);
            return autoDataInput3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

