/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.mayabot.blas.BaseMatrix;
import com.mayabot.blas.ByteBufferVector;
import com.mayabot.blas.FloatMatrix;
import com.mayabot.blas.MutableFloatArrayMatrix;
import com.mayabot.blas.MutableFloatMatrix;
import com.mayabot.blas.Vector;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0096\u0002J\u0019\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/mayabot/blas/ByteBufferMatrix;", "Lcom/mayabot/blas/BaseMatrix;", "Lcom/mayabot/blas/FloatMatrix;", "rows", "", "cols", "data", "Ljava/nio/ByteBuffer;", "(IILjava/nio/ByteBuffer;)V", "getData", "()Ljava/nio/ByteBuffer;", "get", "Lcom/mayabot/blas/Vector;", "row", "", "i", "j", "index", "toMutableFloatMatrix", "Lcom/mayabot/blas/MutableFloatMatrix;", "write", "", "channel", "Ljava/nio/channels/FileChannel;", "maya-simple-blas"})
public final class ByteBufferMatrix
extends BaseMatrix
implements FloatMatrix {
    @NotNull
    private final ByteBuffer data;

    private final int index(int i, int j) {
        return i * this.getCols() + j;
    }

    @Override
    @NotNull
    public Vector get(int row) {
        return new ByteBufferVector(this.data, row * this.getCols(), this.getCols());
    }

    @Override
    public float get(int i, int j) {
        return this.data.getFloat(this.index(i, j) << 2);
    }

    @Override
    public void write(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.data.position(0);
        this.data.limit(this.data.capacity());
        channel.write(this.data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableFloatMatrix toMutableFloatMatrix() {
        MutableFloatArrayMatrix inputMatrix = new MutableFloatArrayMatrix(this.getRows(), this.getCols());
        int n = 0;
        int n2 = this.getRows();
        while (n < n2) {
            void i;
            inputMatrix.get((int)i).plusAssign(this.get((int)i));
            ++i;
        }
        return inputMatrix;
    }

    @NotNull
    public final ByteBuffer getData() {
        return this.data;
    }

    public ByteBufferMatrix(int rows, int cols, @NotNull ByteBuffer data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super(rows, cols);
        this.data = data;
    }
}

