/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.google.common.base.Preconditions;
import com.mayabot.blas.MutableFloatArrayVector;
import com.mayabot.blas.MutableVector;
import com.mayabot.blas.Vector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0011\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/mayabot/blas/FloatArrayVector;", "Lcom/mayabot/blas/Vector;", "data", "", "([F)V", "offset", "", "length", "([FII)V", "access", "", "call", "Lkotlin/Function2;", "", "check", "copy", "Lcom/mayabot/blas/MutableVector;", "get", "index", "minusTo", "v", "norm2", "norm2Pow", "plusTo", "prod", "subVector", "size", "times", "toString", "", "Companion", "maya-simple-blas"})
public class FloatArrayVector
implements Vector {
    @JvmField
    @NotNull
    protected final float[] data;
    @JvmField
    protected final int offset;
    @JvmField
    protected final int length;
    private static final long serialVersionUID = 112L;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector subVector(int offset, int size) {
        float[] result = new float[size];
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            void v0 = i;
            result[v0] = result[v0] + this.get((int)(i + offset));
            ++i;
        }
        return new FloatArrayVector(result, 0, size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector plusTo(@NotNull Vector v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Preconditions.checkArgument((this.length == v.length() ? 1 : 0) != 0);
        float[] result = new float[this.length];
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            result[i] = this.get((int)i) + v.get((int)i);
            ++i;
        }
        return new FloatArrayVector(result, 0, this.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vector minusTo(@NotNull Vector v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Preconditions.checkArgument((this.length == v.length() ? 1 : 0) != 0);
        float[] result = new float[this.length];
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            result[i] = this.get((int)i) - v.get((int)i);
            ++i;
        }
        return new FloatArrayVector(result, 0, this.length);
    }

    @Override
    public float get(int index) {
        return this.data[index + this.offset];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public float times(@NotNull Vector v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return this.prod(v);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float prod(@NotNull Vector v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        float result = 0.0f;
        int j = 0;
        int n = this.offset;
        int n2 = this.offset + this.length;
        while (n < n2) {
            void i;
            result += this.data[i] * v.get(j++);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void access(@NotNull Function2<? super Integer, ? super Float, Unit> call) {
        Intrinsics.checkParameterIsNotNull(call, (String)"call");
        int j = 0;
        int n = this.offset;
        int n2 = this.offset + this.length;
        while (n < n2) {
            void i;
            Integer n3 = j;
            ++j;
            call.invoke((Object)n3, (Object)Float.valueOf(this.data[i]));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float norm2() {
        float sum = 0.0f;
        int n = this.offset;
        int n2 = this.offset + this.length;
        while (n < n2) {
            void i;
            float x = this.data[i];
            sum += x * x;
            ++i;
        }
        return (float)Math.sqrt(sum);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float norm2Pow() {
        float sum = 0.0f;
        int n = this.offset;
        int n2 = this.offset + this.length;
        while (n < n2) {
            void i;
            float x = this.data[i];
            sum += x * x;
            ++i;
        }
        return sum;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check() {
        int n = this.offset;
        int n2 = this.offset + this.length;
        while (n < n2) {
            void i;
            float f = this.data[i];
            float f2 = f;
            Preconditions.checkArgument((!Float.isNaN(f2) ? 1 : 0) != 0);
            f2 = f;
            Preconditions.checkArgument((!Float.isInfinite(f2) ? 1 : 0) != 0);
            ++i;
        }
    }

    @NotNull
    public String toString() {
        if (this.length() == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int iMax = this.length() - 1;
        int end = this.offset + iMax;
        int i = this.offset;
        while (true) {
            b.append(this.data[i]);
            if (i == end) {
                String string = b.append(']').toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.append(']').toString()");
                return string;
            }
            b.append(", ");
            ++i;
        }
    }

    @Override
    @NotNull
    public MutableVector copy() {
        float[] dest = new float[this.length];
        System.arraycopy(this.data, this.offset, dest, 0, this.length);
        return new MutableFloatArrayVector(dest, 0, this.length);
    }

    public FloatArrayVector(@NotNull float[] data, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public FloatArrayVector(@NotNull float[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this(data, 0, data.length);
    }

    @Override
    @NotNull
    public Vector divTo(float f) {
        return Vector.DefaultImpls.divTo(this, f);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mayabot/blas/FloatArrayVector$Companion;", "", "()V", "serialVersionUID", "", "maya-simple-blas"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

