/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.mayabot.blas.AreaByteBufferMatrix;
import com.mayabot.blas.AutoDataInput;
import com.mayabot.blas.FloatArrayMatrix;
import com.mayabot.blas.FloatMatrix;
import com.mayabot.blas.MutableByteBufferMatrix;
import com.mayabot.blas.MutableFloatArrayMatrix;
import com.mayabot.blas.MutableFloatMatrix;
import com.mayabot.blas.Vector;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014J\b\u0010\u0002\u001a\u00020\u0003H&J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u00a6\u0002J\u0019\u0010\u0004\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u00a6\u0002J\b\u0010\n\u001a\u00020\u0003H&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a8\u0006\u0015"}, d2={"Lcom/mayabot/blas/FloatMatrix;", "Ljava/io/Serializable;", "cols", "", "get", "Lcom/mayabot/blas/Vector;", "row", "", "i", "j", "rows", "save", "", "file", "Ljava/io/File;", "toMutableFloatMatrix", "Lcom/mayabot/blas/MutableFloatMatrix;", "write", "channel", "Ljava/nio/channels/FileChannel;", "Companion", "maya-simple-blas"})
public interface FloatMatrix
extends Serializable {
    public static final Companion Companion = com.mayabot.blas.FloatMatrix$Companion.$$INSTANCE;

    public int rows();

    public int cols();

    @NotNull
    public Vector get(int var1);

    public float get(int var1, int var2);

    public void write(@NotNull FileChannel var1);

    public void save(@NotNull File var1);

    @NotNull
    public MutableFloatMatrix toMutableFloatMatrix();

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void save(FloatMatrix $this, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Object object = file;
            object = new FileOutputStream((File)object).getChannel();
            Throwable throwable = null;
            try {
                FileChannel it;
                FileChannel fileChannel = it = (FileChannel)object;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"it");
                Companion.writeInt(fileChannel, $this.rows());
                Companion.writeInt(it, $this.cols());
                $this.write(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/mayabot/blas/FloatMatrix$Companion;", "", "()V", "byteBufferMatrix", "Lcom/mayabot/blas/MutableByteBufferMatrix;", "rows", "", "cols", "directByteBufferMatrix", "floatArrayMatrix", "Lcom/mayabot/blas/MutableFloatArrayMatrix;", "loadMatrix", "Lcom/mayabot/blas/FloatMatrix;", "file", "Ljava/io/File;", "mmap", "", "readOnlyFloatArrayMatrix", "Lcom/mayabot/blas/FloatArrayMatrix;", "data", "", "readInt", "Ljava/nio/channels/FileChannel;", "writeInt", "", "value", "maya-simple-blas"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final MutableByteBufferMatrix byteBufferMatrix(int rows, int cols) {
            return new MutableByteBufferMatrix(rows, cols, false);
        }

        @NotNull
        public final MutableByteBufferMatrix directByteBufferMatrix(int rows, int cols) {
            return new MutableByteBufferMatrix(rows, cols, true);
        }

        @NotNull
        public final MutableFloatArrayMatrix floatArrayMatrix(int rows, int cols) {
            return new MutableFloatArrayMatrix(rows, cols);
        }

        @NotNull
        public final FloatArrayMatrix readOnlyFloatArrayMatrix(int rows, int cols, @NotNull float[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return new FloatArrayMatrix(rows, cols, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final FloatMatrix loadMatrix(@NotNull File file, boolean mmap) {
            FloatMatrix floatMatrix;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            loadMatrix.1 pages$ = loadMatrix.1.INSTANCE;
            if (mmap) {
                Object object = file;
                object = new FileInputStream((File)object).getChannel();
                Throwable throwable = null;
                try {
                    Object it = (FileChannel)object;
                    FileChannel fileChannel = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"it");
                    int rows = this.readInt(fileChannel);
                    int cols2 = this.readInt((FileChannel)it);
                    int areaRows = 0;
                    while (areaRows * cols2 < 0x10000000) {
                        areaRows += 10;
                    }
                    long fileSize = ((FileChannel)it).size();
                    long arrayBytes = fileSize - (long)8;
                    int areaCount = loadMatrix.1.INSTANCE.invoke(arrayBytes, 4 * areaRows * cols2);
                    int areaBytes = areaRows * cols2 * 4;
                    long lastBytes = arrayBytes % (long)(areaRows * cols2 * 4);
                    ArrayList list = new ArrayList();
                    int n = 0;
                    int n2 = areaCount;
                    while (n < n2) {
                        void a;
                        long len = a == areaCount - 1 ? lastBytes : (long)areaBytes;
                        Collection collection = list;
                        MappedByteBuffer mappedByteBuffer = ((FileChannel)it).map(FileChannel.MapMode.READ_ONLY, (long)8 + (long)a * (long)areaBytes, len);
                        collection.add(mappedByteBuffer);
                        ++a;
                    }
                    it = new AreaByteBufferMatrix(rows, cols2, list);
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                floatMatrix = (FloatMatrix)it;
            } else {
                AutoDataInput dataInput = AutoDataInput.Companion.open(file);
                int rows = dataInput.readInt();
                int cols = dataInput.readInt();
                float[] floatArray = new float[rows * cols];
                int cols2 = 0;
                int n = rows * cols;
                while (cols2 < n) {
                    void i;
                    floatArray[i] = dataInput.readFloat();
                    ++i;
                }
                floatMatrix = this.readOnlyFloatArrayMatrix(rows, cols, floatArray);
            }
            return floatMatrix;
        }

        private final void writeInt(@NotNull FileChannel $receiver, int value) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).putInt(value);
            FileChannel fileChannel = $receiver;
            ByteBuffer $receiver2 = byteBuffer;
            $receiver2.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            fileChannel.write(byteBuffer2);
        }

        private final int readInt(@NotNull FileChannel $receiver) {
            ByteBuffer b = ByteBuffer.allocate(4);
            $receiver.read(b);
            b.flip();
            ByteBuffer byteBuffer = b;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"b");
            return byteBuffer.getInt();
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

