/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.mayabot.blas.BaseMatrix;
import com.mayabot.blas.MutableByteBufferVector;
import com.mayabot.blas.MutableFloatMatrix;
import com.mayabot.blas.MutableVector;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0096\u0002J\u0019\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0096\u0002J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J!\u0010\"\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J\b\u0010#\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/mayabot/blas/MutableByteBufferMatrix;", "Lcom/mayabot/blas/BaseMatrix;", "Lcom/mayabot/blas/MutableFloatMatrix;", "()V", "rows", "", "cols", "direct", "", "(IIZ)V", "data", "Ljava/nio/ByteBuffer;", "getData", "()Ljava/nio/ByteBuffer;", "length", "rnd", "Ljava/util/Random;", "rowview", "", "Lcom/mayabot/blas/MutableByteBufferVector;", "[Lcom/mayabot/blas/MutableByteBufferVector;", "fill", "", "v", "", "gaussRandom", "sd", "", "get", "Lcom/mayabot/blas/MutableVector;", "row", "i", "j", "index", "set", "toMutableFloatMatrix", "uniform", "a", "write", "channel", "Ljava/nio/channels/FileChannel;", "maya-simple-blas"})
public final class MutableByteBufferMatrix
extends BaseMatrix
implements MutableFloatMatrix {
    private int length;
    @NotNull
    private final ByteBuffer data;
    private final Random rnd;
    private final MutableByteBufferVector[] rowview;

    @NotNull
    public final ByteBuffer getData() {
        return this.data;
    }

    private final int index(int i, int j) {
        return i * this.getCols() + j;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull Number a) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        float a2 = a.floatValue();
        float lower = -a2;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.length)), (int)4);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                this.data.putFloat((int)i, this.rnd.nextFloat() * (a2 - lower) + lower);
                if (i == n2) break;
                i += n3;
            }
        }
    }

    @Override
    @NotNull
    public MutableFloatMatrix toMutableFloatMatrix() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void gaussRandom(@NotNull Number sd) {
        Intrinsics.checkParameterIsNotNull((Object)sd, (String)"sd");
        float sd2 = sd.floatValue();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.length)), (int)4);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                this.data.putFloat((int)i, (float)(this.rnd.nextGaussian() * (double)sd2));
                if (i == n2) break;
                n = i + n3;
            }
        }
    }

    @Override
    @NotNull
    public MutableVector get(int row) {
        return this.rowview[row];
    }

    @Override
    public float get(int i, int j) {
        return this.data.getFloat(this.index(i, j) << 2);
    }

    @Override
    public void set(int i, int j, float v) {
        this.data.putFloat(this.index(i, j) << 2, v);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(float v) {
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.length)), (int)4);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                this.data.putFloat((int)i, v);
                if (i == n2) break;
                n = i + n3;
            }
        }
    }

    @Override
    public void write(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.data.position(0);
        this.data.limit(this.data.capacity());
        channel.write(this.data);
    }

    /*
     * WARNING - void declaration
     */
    public MutableByteBufferMatrix(int rows, int cols, boolean direct) {
        super(rows, cols);
        MutableByteBufferVector[] mutableByteBufferVectorArray;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        ByteBuffer byteBuffer;
        this.length = rows * cols;
        if (direct) {
            byteBuffer = ByteBuffer.allocateDirect(this.length << 2);
            if (byteBuffer == null) {
                Intrinsics.throwNpe();
            }
        } else {
            byteBuffer = ByteBuffer.allocateDirect(this.length << 2);
            if (byteBuffer == null) {
                Intrinsics.throwNpe();
            }
        }
        this.data = byteBuffer;
        this.rnd = new Random();
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)rows);
        MutableByteBufferMatrix mutableByteBufferMatrix = this;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void index;
            int item$iv$iv = ((IntIterator)iterator).nextInt();
            int n = index$iv$iv++;
            int n2 = item$iv$iv;
            int n3 = n;
            mutableByteBufferVectorArray = destination$iv$iv;
            MutableByteBufferVector mutableByteBufferVector = new MutableByteBufferVector(this.data, (int)(index * cols), cols);
            mutableByteBufferVectorArray.add(mutableByteBufferVector);
        }
        mutableByteBufferVectorArray = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)mutableByteBufferVectorArray;
        MutableByteBufferVector[] mutableByteBufferVectorArray2 = thisCollection$iv.toArray(new MutableByteBufferVector[0]);
        if (mutableByteBufferVectorArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        mutableByteBufferVectorArray = mutableByteBufferVectorArray2;
        mutableByteBufferMatrix.rowview = mutableByteBufferVectorArray;
    }

    public /* synthetic */ MutableByteBufferMatrix(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        this(n, n2, bl);
    }

    public MutableByteBufferMatrix() {
        this(0, 0, false, 4, null);
    }
}

