/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.blas;

import com.mayabot.blas.BaseMatrix;
import com.mayabot.blas.MutableFloatArrayVector;
import com.mayabot.blas.MutableFloatMatrix;
import com.mayabot.blas.MutableVector;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0096\u0002J\u0019\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0096\u0002J!\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J\b\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006("}, d2={"Lcom/mayabot/blas/MutableFloatArrayMatrix;", "Lcom/mayabot/blas/BaseMatrix;", "Lcom/mayabot/blas/MutableFloatMatrix;", "()V", "rows", "", "cols", "(II)V", "data", "", "getData", "()[F", "setData", "([F)V", "length", "rnd", "Ljava/util/Random;", "rowview", "", "Lcom/mayabot/blas/MutableFloatArrayVector;", "[Lcom/mayabot/blas/MutableFloatArrayVector;", "fill", "", "v", "", "gaussRandom", "sd", "", "get", "Lcom/mayabot/blas/MutableVector;", "row", "i", "j", "set", "toMutableFloatMatrix", "uniform", "a", "write", "channel", "Ljava/nio/channels/FileChannel;", "maya-simple-blas"})
public final class MutableFloatArrayMatrix
extends BaseMatrix
implements MutableFloatMatrix {
    private int length;
    @NotNull
    private float[] data;
    private final Random rnd;
    private final MutableFloatArrayVector[] rowview;

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.getCols() * 4);
        FloatBuffer asFloatBuffer = byteBuffer.asFloatBuffer();
        int n = 0;
        int n2 = this.getRows();
        while (n < n2) {
            void row;
            asFloatBuffer.clear();
            asFloatBuffer.put(this.data, (int)(row * this.getCols()), this.getCols());
            byteBuffer.position(0);
            byteBuffer.limit(this.getCols() * 4);
            channel.write(byteBuffer);
            ++row;
        }
    }

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    public final void setData(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"<set-?>");
        this.data = fArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull Number a) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        float a2 = a.floatValue();
        float lower = -a2;
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            this.data[i] = this.rnd.nextFloat() * (a2 - lower) + lower;
            ++i;
        }
    }

    @Override
    @NotNull
    public MutableFloatMatrix toMutableFloatMatrix() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void gaussRandom(@NotNull Number sd) {
        Intrinsics.checkParameterIsNotNull((Object)sd, (String)"sd");
        float sd2 = sd.floatValue();
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            this.data[i] = (float)(this.rnd.nextGaussian() * (double)sd2);
            ++i;
        }
    }

    @Override
    @NotNull
    public MutableVector get(int row) {
        return this.rowview[row];
    }

    @Override
    public float get(int i, int j) {
        return this.data[i * this.getCols() + j];
    }

    @Override
    public void set(int i, int j, float v) {
        this.data[i * this.getCols() + j] = v;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(float v) {
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            this.data[i] = v;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public MutableFloatArrayMatrix(int rows, int cols) {
        super(rows, cols);
        MutableFloatArrayVector[] mutableFloatArrayVectorArray;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        this.length = rows * cols;
        this.data = new float[this.length];
        this.rnd = new Random();
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)rows);
        MutableFloatArrayMatrix mutableFloatArrayMatrix = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void index;
            int item$iv$iv = ((IntIterator)iterator).nextInt();
            int n = index$iv$iv++;
            int n2 = item$iv$iv;
            int n3 = n;
            mutableFloatArrayVectorArray = destination$iv$iv;
            MutableFloatArrayVector mutableFloatArrayVector = new MutableFloatArrayVector(this.data, (int)(index * cols), cols);
            mutableFloatArrayVectorArray.add(mutableFloatArrayVector);
        }
        mutableFloatArrayVectorArray = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)mutableFloatArrayVectorArray;
        MutableFloatArrayVector[] mutableFloatArrayVectorArray2 = thisCollection$iv.toArray(new MutableFloatArrayVector[0]);
        if (mutableFloatArrayVectorArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        mutableFloatArrayVectorArray = mutableFloatArrayVectorArray2;
        mutableFloatArrayMatrix.rowview = mutableFloatArrayVectorArray;
    }

    public MutableFloatArrayMatrix() {
        this(0, 0);
    }
}

