/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.DriverManagerDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public final class DriverManagerDataSource
extends DriverManagerDataSourceBase
implements DataSource {
    static final MLogger logger = MLog.getLogger(DriverManagerDataSource.class);
    Driver driver;
    boolean driver_class_loaded = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    public DriverManagerDataSource() {
        this(true);
    }

    public DriverManagerDataSource(boolean bl) {
        super(bl);
        this.setUpPropertyListeners();
        String string = C3P0Config.initializeStringPropertyVar("user", null);
        String string2 = C3P0Config.initializeStringPropertyVar("password", null);
        if (string != null) {
            this.setUser(string);
        }
        if (string2 != null) {
            this.setPassword(string2);
        }
    }

    private void setUpPropertyListeners() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("driverClass".equals(propertyChangeEvent.getPropertyName())) {
                    DriverManagerDataSource driverManagerDataSource = DriverManagerDataSource.this;
                    synchronized (driverManagerDataSource) {
                        DriverManagerDataSource.this.setDriverClassLoaded(false);
                        if (DriverManagerDataSource.this.driverClass != null && DriverManagerDataSource.this.driverClass.trim().length() == 0) {
                            DriverManagerDataSource.this.driverClass = null;
                        }
                    }
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    private synchronized boolean isDriverClassLoaded() {
        return this.driver_class_loaded;
    }

    private synchronized void setDriverClassLoaded(boolean bl) {
        this.driver_class_loaded = bl;
        if (!this.driver_class_loaded) {
            this.clearDriver();
        }
    }

    private synchronized void ensureDriverLoaded() throws SQLException {
        block4: {
            try {
                if (!this.isDriverClassLoaded()) {
                    if (this.driverClass != null) {
                        Class.forName(this.driverClass);
                    }
                    this.setDriverClassLoaded(true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Could not load driverClass " + this.driverClass, (Throwable)classNotFoundException);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureDriverLoaded();
        Connection connection = this.driver().connect(this.jdbcUrl, this.properties);
        if (connection == null) {
            throw new SQLException("Apparently, jdbc URL '" + this.jdbcUrl + "' is not valid for the underlying driver [" + this.driver() + "].");
        }
        return connection;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        this.ensureDriverLoaded();
        Connection connection = this.driver().connect(this.jdbcUrl, this.overrideProps(string, string2));
        if (connection == null) {
            throw new SQLException("Apparently, jdbc URL '" + this.jdbcUrl + "' is not valid for the underlying driver [" + this.driver() + "].");
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    @Override
    public synchronized void setJdbcUrl(String string) {
        super.setJdbcUrl(string);
        this.clearDriver();
    }

    public synchronized void setUser(String string) {
        String string2 = this.getUser();
        if (!DriverManagerDataSource.eqOrBothNull(string, string2)) {
            if (string != null) {
                this.properties.put("user", string);
            } else {
                this.properties.remove("user");
            }
            this.pcs.firePropertyChange("user", string2, string);
        }
    }

    public synchronized String getUser() {
        return this.properties.getProperty("user");
    }

    public synchronized void setPassword(String string) {
        String string2 = this.getPassword();
        if (!DriverManagerDataSource.eqOrBothNull(string, string2)) {
            if (string != null) {
                this.properties.put("password", string);
            } else {
                this.properties.remove("password");
            }
            this.pcs.firePropertyChange("password", string2, string);
        }
    }

    public synchronized String getPassword() {
        return this.properties.getProperty("password");
    }

    private final Properties overrideProps(String string, String string2) {
        Properties properties = (Properties)this.properties.clone();
        if (string != null) {
            properties.put("user", string);
        } else {
            properties.remove("user");
        }
        if (string2 != null) {
            properties.put("password", string2);
        } else {
            properties.remove("password");
        }
        return properties;
    }

    private synchronized Driver driver() throws SQLException {
        if (this.driver == null) {
            if (this.driverClass != null && this.forceUseNamedDriverClass) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.finer("Circumventing DriverManager and instantiating driver class '" + this.driverClass + "' directly. (forceUseNamedDriverClass = " + this.forceUseNamedDriverClass + ")");
                }
                try {
                    this.driver = (Driver)Class.forName(this.driverClass).newInstance();
                    this.setDriverClassLoaded(true);
                }
                catch (Exception exception) {
                    SqlUtils.toSQLException((String)("Cannot instantiate specified JDBC driver. Exception while initializing named, forced-to-use driver class'" + this.driverClass + "'"), (Throwable)exception);
                }
            } else {
                this.driver = DriverManager.getDriver(this.jdbcUrl);
            }
        }
        return this.driver;
    }

    private synchronized void clearDriver() {
        this.driver = null;
    }

    private static boolean eqOrBothNull(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.setUpPropertyListeners();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }

    private boolean isWrapperForThis(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.isWrapperForThis(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperForThis(clazz)) {
            return (T)this;
        }
        throw new SQLException(this + " is not a wrapper for or implementation of " + clazz.getName());
    }

    static {
        try {
            Class.forName("java.sql.DriverManager");
        }
        catch (Exception exception) {
            String string = "Could not load the DriverManager class?!?";
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, string);
            }
            throw new InternalError(string);
        }
    }
}

