/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.lang.Coerce;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class C3P0ConfigUtils {
    public static final String PROPS_FILE_RSRC_PATH = "/c3p0.properties";
    public static final String PROPS_FILE_PROP_PFX = "c3p0.";
    public static final int PROPS_FILE_PROP_PFX_LEN = 5;
    private static final String[] MISSPELL_PFXS = new String[]{"/c3pO", "/c3po", "/C3P0", "/C3PO"};
    static final MLogger logger = MLog.getLogger(C3P0ConfigUtils.class);

    public static HashMap extractHardcodedC3P0Defaults(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            for (Method method : C3P0Defaults.class.getMethods()) {
                Object object;
                int n = method.getModifiers();
                if ((n & 1) == 0 || (n & 8) == 0 || method.getParameterTypes().length != 0 || (object = method.invoke(null, (Object[])null)) == null) continue;
                hashMap.put(method.getName(), bl && Coerce.canCoerce((Object)object) ? String.valueOf(object) : object);
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "Failed to extract hardcoded default config!?", (Throwable)exception);
        }
        return hashMap;
    }

    public static HashMap extractHardcodedC3P0Defaults() {
        return C3P0ConfigUtils.extractHardcodedC3P0Defaults(true);
    }

    public static HashMap extractC3P0PropertiesResources() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = C3P0ConfigUtils.findAllOneLevelC3P0Properties();
        for (String string : properties.keySet()) {
            String string2 = (String)properties.get(string);
            if (!string.startsWith(PROPS_FILE_PROP_PFX)) continue;
            hashMap.put(string.substring(5).trim(), string2.trim());
        }
        return hashMap;
    }

    public static C3P0Config configFromFlatDefaults(HashMap hashMap) {
        NamedScope namedScope = new NamedScope();
        namedScope.props.putAll(hashMap);
        HashMap hashMap2 = new HashMap();
        return new C3P0Config(namedScope, hashMap2);
    }

    public static String getPropsFileConfigProperty(String string) {
        return C3P0Config.getPropsFileConfigProperty(string);
    }

    public static Properties findResourceProperties() {
        return C3P0Config.findResourceProperties();
    }

    private static Properties findAllOneLevelC3P0Properties() {
        return C3P0Config.findAllOneLevelC3P0Properties();
    }

    static Properties findAllC3P0SystemProperties() {
        Properties properties;
        block3: {
            properties = new Properties();
            try {
                for (String string : C3P0Defaults.getKnownProperties(null)) {
                    String string2 = PROPS_FILE_PROP_PFX + string;
                    String string3 = System.getProperty(string2);
                    if (string3 == null || string3.trim().length() <= 0) continue;
                    properties.put(string, string3);
                }
            }
            catch (SecurityException securityException) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "A SecurityException occurred while trying to read c3p0 System properties. c3p0 configuration set via System properties may be ignored!", (Throwable)securityException);
            }
        }
        return properties;
    }

    public static Object extractUserOverride(String string, String string2, Map map) {
        Map map2 = (Map)map.get(string2);
        if (map2 != null) {
            return map2.get(string);
        }
        return null;
    }

    public static Boolean extractBooleanOverride(String string, String string2, Map map) {
        Object object = C3P0ConfigUtils.extractUserOverride(string, string2, map);
        if (object == null || object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new ClassCastException("Parameter '" + string + "' as overridden for user '" + string2 + "' is " + object + ", which cannot be converted to Boolean.");
    }

    private C3P0ConfigUtils() {
    }

    static {
        if (logger.isLoggable(MLevel.WARNING) && C3P0ConfigUtils.class.getResource(PROPS_FILE_RSRC_PATH) == null) {
            for (int i = 0; i < MISSPELL_PFXS.length; ++i) {
                String string = MISSPELL_PFXS[i] + ".properties";
                if (C3P0ConfigUtils.class.getResource(MISSPELL_PFXS[i] + ".properties") == null) continue;
                logger.warning("POSSIBLY MISSPELLED c3p0.properties CONFIG RESOURCE FOUND. Please ensure the file name is c3p0.properties, all lower case, with the digit 0 (NOT the letter O) in c3p0. It should be placed  in the top level of c3p0's effective classpath.");
                break;
            }
        }
    }
}

