/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPoolReportingAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.SQLWarnings;
import com.mchange.v2.c3p0.UnifiedConnectionTester;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    private static final boolean ASYNCHRONOUS_CONNECTION_EVENT_LISTENER = false;
    private static final Throwable[] EMPTY_THROWABLE_HOLDER = new Throwable[1];
    static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPool.class);
    final ResourcePool rp;
    final ConnectionEventListener cl = new ConnectionEventListenerImpl();
    final ConnectionTester connectionTester;
    final GooGooStatementCache scache;
    final boolean c3p0PooledConnections;
    final boolean effectiveStatementCache;
    final int checkoutTimeout;
    final AsynchronousRunner sharedTaskRunner;
    final AsynchronousRunner deferredStatementDestroyer;
    final ThrowableHolderPool thp = new ThrowableHolderPool();
    final InUseLockFetcher inUseLockFetcher;
    private RequestBoundaryMarker requestBoundaryMarker;
    private static InUseLockFetcher RESOURCE_ITSELF_IN_USE_LOCK_FETCHER = new ResourceItselfInUseLockFetcher();
    private static InUseLockFetcher C3P0_POOLED_CONNECION_NESTED_LOCK_LOCK_FETCHER = new C3P0PooledConnectionNestedLockLockFetcher();
    private static RequestBoundaryMarker NO_OP_REQUEST_BOUNDARY_MARKER = new NoOpRequestBoundaryMarker();

    public int getStatementDestroyerNumConnectionsInUse() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumConnectionsInUse();
    }

    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatements() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumConnectionsWithDeferredDestroyStatements();
    }

    public int getStatementDestroyerNumDeferredDestroyStatements() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumDeferredDestroyStatements();
    }

    private synchronized RequestBoundaryMarker findRequestBoundaryMarker(PooledConnection pooledConnection) {
        if (this.requestBoundaryMarker != null) {
            return this.requestBoundaryMarker;
        }
        if (pooledConnection instanceof AbstractC3P0PooledConnection) {
            AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
            Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
            try {
                Method method;
                Method method2 = connection.getClass().getMethod("beginRequest", new Class[0]);
                if (!method2.isAccessible()) {
                    method2.setAccessible(true);
                }
                if (!(method = connection.getClass().getMethod("endRequest", new Class[0])).isAccessible()) {
                    method.setAccessible(true);
                }
                logger.log(MLevel.FINEST, "Request boundary methods found");
                this.requestBoundaryMarker = new LiveRequestBoundaryMarker(method2, method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.log(MLevel.WARNING, "Request boundary methods not found.");
                this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
            }
            catch (SecurityException securityException) {
                logger.log(MLevel.WARNING, "Could not make boundary methods accessible.");
                this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
            }
        } else {
            this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
        }
        return this.requestBoundaryMarker;
    }

    private void markBeginRequest(PooledConnection pooledConnection) {
        this.findRequestBoundaryMarker(pooledConnection).attemptNotifyBeginRequest(pooledConnection);
    }

    private void markEndRequest(PooledConnection pooledConnection) {
        this.findRequestBoundaryMarker(pooledConnection).attemptNotifyEndRequest(pooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(final ConnectionPoolDataSource connectionPoolDataSource, final DbAuth dbAuth, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8, int n9, int n10, int n11, int n12, int n13, boolean bl2, boolean bl3, final boolean bl4, final boolean bl5, int n14, int n15, final ConnectionTester connectionTester, final ConnectionCustomizer connectionCustomizer, final String string, ResourcePoolFactory resourcePoolFactory, ThreadPoolReportingAsynchronousRunner threadPoolReportingAsynchronousRunner, ThreadPoolReportingAsynchronousRunner threadPoolReportingAsynchronousRunner2, final String string2) throws SQLException {
        try {
            this.scache = n14 > 0 && n15 > 0 ? new DoubleMaxStatementCache((AsynchronousRunner)threadPoolReportingAsynchronousRunner, (AsynchronousRunner)threadPoolReportingAsynchronousRunner2, n14, n15) : (n15 > 0 ? new PerConnectionMaxOnlyStatementCache((AsynchronousRunner)threadPoolReportingAsynchronousRunner, (AsynchronousRunner)threadPoolReportingAsynchronousRunner2, n15) : (n14 > 0 ? new GlobalMaxOnlyStatementCache((AsynchronousRunner)threadPoolReportingAsynchronousRunner, (AsynchronousRunner)threadPoolReportingAsynchronousRunner2, n14) : null));
            this.connectionTester = connectionTester;
            this.checkoutTimeout = n7;
            this.sharedTaskRunner = threadPoolReportingAsynchronousRunner;
            this.deferredStatementDestroyer = threadPoolReportingAsynchronousRunner2;
            this.c3p0PooledConnections = connectionPoolDataSource instanceof WrapperConnectionPoolDataSource;
            this.effectiveStatementCache = this.c3p0PooledConnections && this.scache != null;
            this.inUseLockFetcher = this.c3p0PooledConnections ? C3P0_POOLED_CONNECION_NESTED_LOCK_LOCK_FETCHER : RESOURCE_ITSELF_IN_USE_LOCK_FETCHER;
            class PooledConnectionResourcePoolManager
            implements ResourcePool.Manager {
                final boolean connectionTesterIsDefault;

                PooledConnectionResourcePoolManager() {
                    this.connectionTesterIsDefault = connectionTester instanceof DefaultConnectionTester;
                }

                @Override
                public Object acquireResource() throws Exception {
                    Object object;
                    PooledConnection pooledConnection;
                    if (connectionCustomizer == null) {
                        pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? connectionPoolDataSource.getPooledConnection() : connectionPoolDataSource.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
                    } else {
                        try {
                            object = (WrapperConnectionPoolDataSourceBase)((Object)connectionPoolDataSource);
                            pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(connectionCustomizer, string2) : ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(dbAuth.getUser(), dbAuth.getPassword(), connectionCustomizer, string2);
                        }
                        catch (ClassCastException classCastException) {
                            throw SqlUtils.toSQLException((String)("Cannot use a ConnectionCustomizer with a non-c3p0 ConnectionPoolDataSource. ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName()), (Throwable)classCastException);
                        }
                    }
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else {
                                logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                            }
                        }
                        object = null;
                        try {
                            C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse(pooledConnection);
                            object = pooledConnection.getConnection();
                            SQLWarnings.logAndClearWarnings((Connection)object);
                        }
                        finally {
                            ConnectionUtils.attemptClose((Connection)object);
                            C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse(pooledConnection);
                        }
                        PooledConnection pooledConnection2 = pooledConnection;
                        return pooledConnection2;
                    }
                    catch (Exception exception) {
                        block20: {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "A PooledConnection was acquired, but an Exception occurred while preparing it for use. Attempting to destroy.", (Throwable)exception);
                            }
                            try {
                                this.destroyResource(pooledConnection, false);
                            }
                            catch (Exception exception2) {
                                if (!logger.isLoggable(MLevel.WARNING)) break block20;
                                logger.log(MLevel.WARNING, "An Exception occurred while trying to close partially acquired PooledConnection.", (Throwable)exception2);
                            }
                        }
                        throw exception;
                    }
                    finally {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest(this + ".acquireResource() returning. ");
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishResourceOnCheckout(Object object) throws Exception {
                    Object object2 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(object);
                    synchronized (object2) {
                        if (connectionCustomizer != null) {
                            Connection connection = null;
                            try {
                                connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                C3P0PooledConnectionPool.this.waitMarkPhysicalConnectionInUse(connection);
                                if (bl4) {
                                    if (logger.isLoggable(MLevel.FINER)) {
                                        this.finerLoggingTestPooledConnection(object, "CHECKOUT");
                                    } else {
                                        this.testPooledConnection(object);
                                    }
                                }
                                connectionCustomizer.onCheckOut(connection, string2);
                            }
                            catch (ClassCastException classCastException) {
                                throw SqlUtils.toSQLException((String)("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName()), (Throwable)classCastException);
                            }
                            finally {
                                C3P0PooledConnectionPool.this.unmarkPhysicalConnectionInUse(connection);
                            }
                        }
                        if (bl4) {
                            PooledConnection pooledConnection = (PooledConnection)object;
                            try {
                                C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse(pooledConnection);
                                assert (!Boolean.FALSE.equals(C3P0PooledConnectionPool.this.pooledConnectionInUse(pooledConnection)));
                                if (logger.isLoggable(MLevel.FINER)) {
                                    this.finerLoggingTestPooledConnection(pooledConnection, "CHECKOUT");
                                } else {
                                    this.testPooledConnection(pooledConnection);
                                }
                            }
                            finally {
                                C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse(pooledConnection);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void refurbishResourceOnCheckin(Object var1_1) throws Exception {
                    var2_2 = null;
                    try {
                        var3_3 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(var1_1);
                        synchronized (var3_3) {
                            if (connectionCustomizer != null) {
                                var4_4 = null;
                                try {
                                    var4_4 = ((AbstractC3P0PooledConnection)var1_1).getPhysicalConnection();
                                    C3P0PooledConnectionPool.access$500(C3P0PooledConnectionPool.this, var4_4);
                                    connectionCustomizer.onCheckIn(var4_4, string2);
                                    SQLWarnings.logAndClearWarnings(var4_4);
                                    if (!bl5) ** GOTO lbl40
                                    if (C3P0PooledConnectionPool.logger.isLoggable(MLevel.FINER)) {
                                        this.finerLoggingTestPooledConnection(var1_1, "CHECKIN");
                                    }
                                    this.testPooledConnection(var1_1);
                                }
                                catch (ClassCastException var5_6) {
                                    throw SqlUtils.toSQLException((String)("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + var1_1 + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName()), (Throwable)var5_6);
                                }
                                finally {
                                    C3P0PooledConnectionPool.access$600(C3P0PooledConnectionPool.this, var4_4);
                                }
                            } else {
                                var4_5 = (PooledConnection)var1_1;
                                var5_7 = null;
                                try {
                                    C3P0PooledConnectionPool.access$300(C3P0PooledConnectionPool.this, var4_5);
                                    var5_7 = var4_5.getConnection();
                                    SQLWarnings.logAndClearWarnings(var5_7);
                                    if (bl5) {
                                        if (C3P0PooledConnectionPool.logger.isLoggable(MLevel.FINER)) {
                                            this.finerLoggingTestPooledConnection(var1_1, var5_7, "CHECKIN");
                                        } else {
                                            this.testPooledConnection(var1_1, var5_7);
                                        }
                                    }
                                }
                                finally {
                                    var2_2 = var5_7;
                                    C3P0PooledConnectionPool.access$400(C3P0PooledConnectionPool.this, var4_5);
                                }
                            }
                        }
                    }
                    catch (Throwable var9_11) {
                        ConnectionUtils.attemptClose(var2_2);
                        throw var9_11;
                    }
                    ConnectionUtils.attemptClose((Connection)var2_2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishIdleResource(Object object) throws Exception {
                    Object object2 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(object);
                    synchronized (object2) {
                        PooledConnection pooledConnection = (PooledConnection)object;
                        try {
                            C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse(pooledConnection);
                            if (logger.isLoggable(MLevel.FINER)) {
                                this.finerLoggingTestPooledConnection(object, "IDLE CHECK");
                            } else {
                                this.testPooledConnection(object);
                            }
                        }
                        finally {
                            C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse(pooledConnection);
                        }
                    }
                }

                private void finerLoggingTestPooledConnection(Object object, String string3) throws Exception {
                    this.finerLoggingTestPooledConnection(object, null, string3);
                }

                private void finerLoggingTestPooledConnection(Object object, Connection connection, String string3) throws Exception {
                    logger.finer("Testing PooledConnection [" + object + "] on " + string3 + ".");
                    try {
                        this.testPooledConnection(object, connection);
                        logger.finer("Test of PooledConnection [" + object + "] on " + string3 + " has SUCCEEDED.");
                    }
                    catch (Exception exception) {
                        logger.log(MLevel.FINER, "Test of PooledConnection [" + object + "] on " + string3 + " has FAILED.", (Throwable)exception);
                        exception.fillInStackTrace();
                        throw exception;
                    }
                }

                private void testPooledConnection(Object object) throws Exception {
                    this.testPooledConnection(object, null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void testPooledConnection(Object object, Connection connection) throws Exception {
                    int n;
                    Object object2;
                    PooledConnection pooledConnection = (PooledConnection)object;
                    assert (!Boolean.FALSE.equals(C3P0PooledConnectionPool.this.pooledConnectionInUse(pooledConnection)));
                    Throwable[] throwableArray = EMPTY_THROWABLE_HOLDER;
                    Connection connection2 = null;
                    Throwable throwable = null;
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            object2 = string == null && this.connectionTesterIsDefault && C3P0PooledConnectionPool.this.c3p0PooledConnections ? ((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection() : (connection == null ? (connection2 = pooledConnection.getConnection()) : connection);
                        } else if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                            object2 = ((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection();
                        } else {
                            Object object3 = object2 = connection == null ? (connection2 = pooledConnection.getConnection()) : connection;
                        }
                        if (string == null) {
                            n = connectionTester.activeCheckConnection((Connection)object2);
                        } else if (connectionTester instanceof UnifiedConnectionTester) {
                            throwableArray = C3P0PooledConnectionPool.this.thp.getThrowableHolder();
                            n = ((UnifiedConnectionTester)connectionTester).activeCheckConnection((Connection)object2, string, throwableArray);
                        } else if (connectionTester instanceof QueryConnectionTester) {
                            n = ((QueryConnectionTester)connectionTester).activeCheckConnection((Connection)object2, string);
                        } else {
                            logger.warning("[c3p0] testQuery '" + string + "' ignored. Please set a ConnectionTester that implements com.mchange.v2.c3p0.QueryConnectionTester, or use the DefaultConnectionTester, to test with the testQuery.");
                            n = connectionTester.activeCheckConnection((Connection)object2);
                        }
                    }
                    catch (Exception exception) {
                        logger.log(MLevel.FINE, "A Connection test failed with an Exception.", (Throwable)exception);
                        n = -1;
                        throwable = exception;
                    }
                    finally {
                        if (throwable == null) {
                            throwable = throwableArray[0];
                        } else if (throwableArray[0] != null && logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableArray[0]);
                        }
                        if (throwableArray != EMPTY_THROWABLE_HOLDER) {
                            C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableArray);
                        }
                        ConnectionUtils.attemptClose((Connection)connection2);
                    }
                    switch (n) {
                        case 0: {
                            break;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            object2 = throwable == null ? new SQLException("Connection is invalid") : SqlUtils.toSQLException((String)"Connection is invalid", (Throwable)throwable);
                            throw object2;
                        }
                        default: {
                            throw new Error("Bad Connection Tester (" + connectionTester + ") returned invalid status (" + n + ").");
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void destroyResource(Object object, boolean bl) throws Exception {
                    Object object2 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(object);
                    synchronized (object2) {
                        try {
                            block14: {
                                C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse((PooledConnection)object);
                                if (connectionCustomizer != null) {
                                    Connection connection = null;
                                    try {
                                        connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                        connectionCustomizer.onDestroy(connection, string2);
                                    }
                                    catch (ClassCastException classCastException) {
                                        throw SqlUtils.toSQLException((String)("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName()), (Throwable)classCastException);
                                    }
                                    catch (Exception exception) {
                                        if (!logger.isLoggable(MLevel.WARNING)) break block14;
                                        logger.log(MLevel.WARNING, "An exception occurred while executing the onDestroy() method of " + connectionCustomizer + ". c3p0 will attempt to destroy the target Connection regardless, but this issue  should be investigated and fixed.", (Throwable)exception);
                                    }
                                }
                            }
                            if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)object).closeMaybeCheckedOut(bl);
                            } else {
                                ((PooledConnection)object).close();
                            }
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse((PooledConnection)object);
                        }
                    }
                }
            }
            PooledConnectionResourcePoolManager pooledConnectionResourcePoolManager = new PooledConnectionResourcePoolManager();
            ResourcePoolFactory resourcePoolFactory2 = resourcePoolFactory;
            synchronized (resourcePoolFactory2) {
                resourcePoolFactory.setMin(n);
                resourcePoolFactory.setMax(n2);
                resourcePoolFactory.setStart(n3);
                resourcePoolFactory.setIncrement(n4);
                resourcePoolFactory.setIdleResourceTestPeriod(n8 * 1000);
                resourcePoolFactory.setResourceMaxIdleTime(n9 * 1000);
                resourcePoolFactory.setExcessResourceMaxIdleTime(n10 * 1000);
                resourcePoolFactory.setResourceMaxAge(n11 * 1000);
                resourcePoolFactory.setExpirationEnforcementDelay(n12 * 1000);
                resourcePoolFactory.setDestroyOverdueResourceTime(n13 * 1000);
                resourcePoolFactory.setDebugStoreCheckoutStackTrace(bl2);
                resourcePoolFactory.setForceSynchronousCheckins(bl3);
                resourcePoolFactory.setAcquisitionRetryAttempts(n5);
                resourcePoolFactory.setAcquisitionRetryDelay(n6);
                resourcePoolFactory.setBreakOnAcquisitionFailure(bl);
                this.rp = resourcePoolFactory.createPool(pooledConnectionResourcePoolManager);
            }
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException((Throwable)((Object)resourcePoolException));
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            PooledConnection pooledConnection = (PooledConnection)this.checkoutAndMarkConnectionInUse();
            pooledConnection.addConnectionEventListener(this.cl);
            this.markBeginRequest(pooledConnection);
            return pooledConnection;
        }
        catch (TimeoutException timeoutException) {
            throw SqlUtils.toSQLException((String)"An attempt by a client to checkout a Connection has timed out.", (Throwable)((Object)timeoutException));
        }
        catch (CannotAcquireResourceException cannotAcquireResourceException) {
            throw SqlUtils.toSQLException((String)"Connections could not be acquired from the underlying database!", (String)"08001", (Throwable)((Object)cannotAcquireResourceException));
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    private void waitMarkPhysicalConnectionInUse(Connection connection) throws InterruptedException {
        if (this.effectiveStatementCache) {
            this.scache.waitMarkConnectionInUse(connection);
        }
    }

    private boolean tryMarkPhysicalConnectionInUse(Connection connection) {
        return this.effectiveStatementCache ? this.scache.tryMarkConnectionInUse(connection) : true;
    }

    private void unmarkPhysicalConnectionInUse(Connection connection) {
        if (this.effectiveStatementCache) {
            this.scache.unmarkConnectionInUse(connection);
        }
    }

    private void waitMarkPooledConnectionInUse(PooledConnection pooledConnection) throws InterruptedException {
        if (this.c3p0PooledConnections) {
            this.waitMarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
    }

    private boolean tryMarkPooledConnectionInUse(PooledConnection pooledConnection) {
        if (this.c3p0PooledConnections) {
            return this.tryMarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
        return true;
    }

    private void unmarkPooledConnectionInUse(PooledConnection pooledConnection) {
        if (this.c3p0PooledConnections) {
            this.unmarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
    }

    private Boolean physicalConnectionInUse(Connection connection) throws InterruptedException {
        if (connection != null && this.effectiveStatementCache) {
            return this.scache.inUse(connection);
        }
        return null;
    }

    private Boolean pooledConnectionInUse(PooledConnection pooledConnection) throws InterruptedException {
        if (pooledConnection != null && this.effectiveStatementCache) {
            return this.scache.inUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkoutAndMarkConnectionInUse() throws TimeoutException, CannotAcquireResourceException, ResourcePoolException, InterruptedException {
        Object object = null;
        boolean bl = false;
        while (!bl) {
            try {
                object = this.rp.checkoutResource(this.checkoutTimeout);
                if (object instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)object;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    bl = this.tryMarkPhysicalConnectionInUse(connection);
                    continue;
                }
                bl = true;
            }
            finally {
                try {
                    if (bl || object == null) continue;
                    this.rp.checkinResource(object);
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Failed to check in a Connection that was unusable due to pending Statement closes.", (Throwable)exception);
                }
            }
        }
        return object;
    }

    private void unmarkConnectionInUseAndCheckin(PooledConnection pooledConnection) throws ResourcePoolException {
        block3: {
            if (this.effectiveStatementCache) {
                try {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    this.unmarkPhysicalConnectionInUse(connection);
                }
                catch (ClassCastException classCastException) {
                    if (!logger.isLoggable(MLevel.SEVERE)) break block3;
                    logger.log(MLevel.SEVERE, "You are checking a non-c3p0 PooledConnection implementation intoa c3p0 PooledConnectionPool instance that expects only c3p0-generated PooledConnections.This isn't good, and may indicate a c3p0 bug, or an unusual (and unspported) use of the c3p0 library.", (Throwable)classCastException);
                }
            }
        }
        this.rp.checkinResource(pooledConnection);
    }

    public void checkinPooledConnection(PooledConnection pooledConnection) throws SQLException {
        try {
            pooledConnection.removeConnectionEventListener(this.cl);
            this.unmarkConnectionInUseAndCheckin(pooledConnection);
            this.markEndRequest(pooledConnection);
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException((Throwable)((Object)resourcePoolException));
        }
    }

    public float getEffectivePropertyCycle() throws SQLException {
        try {
            return (float)this.rp.getEffectiveExpirationEnforcementDelay() / 1000.0f;
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException((Throwable)((Object)resourcePoolException));
        }
    }

    public int getNumThreadsAwaitingCheckout() throws SQLException {
        try {
            return this.rp.getNumCheckoutWaiters();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException((Throwable)((Object)resourcePoolException));
        }
    }

    public int getStatementCacheNumStatements() {
        return this.scache == null ? 0 : this.scache.getNumStatements();
    }

    public int getStatementCacheNumCheckedOut() {
        return this.scache == null ? 0 : this.scache.getNumStatementsCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements() {
        return this.scache == null ? 0 : this.scache.getNumConnectionsWithCachedStatements();
    }

    public String dumpStatementCacheStatus() {
        return this.scache == null ? "Statement caching disabled." : this.scache.dumpStatementCacheStatus();
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean bl) throws SQLException {
        Object object = null;
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException sQLException) {
            object = sQLException;
        }
        try {
            this.rp.close(bl);
        }
        catch (ResourcePoolException resourcePoolException) {
            if (object != null && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while closing the StatementCache.", (Throwable)object);
            }
            object = resourcePoolException;
        }
        if (object != null) {
            throw SqlUtils.toSQLException((Throwable)object);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public int getNumBusyConnections() throws SQLException {
        try {
            return this.rp.getAwaitingCheckinNotExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public long getStartTime() throws SQLException {
        try {
            return this.rp.getStartTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public long getUpTime() throws SQLException {
        try {
            return this.rp.getUpTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public long getNumFailedCheckins() throws SQLException {
        try {
            return this.rp.getNumFailedCheckins();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public long getNumFailedCheckouts() throws SQLException {
        try {
            return this.rp.getNumFailedCheckouts();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public long getNumFailedIdleTests() throws SQLException {
        try {
            return this.rp.getNumFailedIdleTests();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public Throwable getLastCheckinFailure() throws SQLException {
        try {
            return this.rp.getLastCheckinFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public Throwable getLastCheckoutFailure() throws SQLException {
        try {
            return this.rp.getLastCheckoutFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public Throwable getLastIdleTestFailure() throws SQLException {
        try {
            return this.rp.getLastIdleCheckFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public Throwable getLastConnectionTestFailure() throws SQLException {
        try {
            return this.rp.getLastResourceTestFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public Throwable getLastAcquisitionFailure() throws SQLException {
        try {
            return this.rp.getLastAcquisitionFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, (Throwable)exception);
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    static final class ThrowableHolderPool {
        LinkedList l = new LinkedList();

        ThrowableHolderPool() {
        }

        synchronized Throwable[] getThrowableHolder() {
            if (this.l.size() == 0) {
                return new Throwable[1];
            }
            return (Throwable[])this.l.remove(0);
        }

        synchronized void returnThrowableHolder(Throwable[] throwableArray) {
            throwableArray[0] = null;
            this.l.add(throwableArray);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            this.doCheckinResource(connectionEvent);
        }

        private void doCheckinResource(ConnectionEvent connectionEvent) {
            try {
                C3P0PooledConnectionPool.this.checkinPooledConnection((PooledConnection)connectionEvent.getSource());
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", (Throwable)exception);
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            int n = (pooledConnection = (PooledConnection)connectionEvent.getSource()) instanceof NewPooledConnection ? ((NewPooledConnection)pooledConnection).getConnectionStatus() : -1;
            int n2 = n;
            this.doMarkPoolStatus(pooledConnection, n2);
        }

        private void doMarkPoolStatus(PooledConnection pooledConnection, int n) {
            try {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pooledConnection);
                        break;
                    }
                    case -8: {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("A ConnectionTest has failed, reporting that all previously acquired Connections are likely invalid. The pool will be reset.");
                        }
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") returned invalid status (" + n + ").");
                    }
                }
            }
            catch (ResourcePoolException resourcePoolException) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", (Throwable)((Object)resourcePoolException));
            }
        }
    }

    private static class LiveRequestBoundaryMarker
    implements RequestBoundaryMarker {
        Method beginRequest;
        Method endRequest;

        LiveRequestBoundaryMarker(Method method, Method method2) {
            this.beginRequest = method;
            this.endRequest = method2;
        }

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
            if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                try {
                    this.beginRequest.invoke((Object)connection, new Object[0]);
                    logger.log(MLevel.FINEST, "beginRequest method called");
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Error invoking beginRequest method for connection", (Throwable)exception);
                }
            }
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
            if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                try {
                    this.endRequest.invoke((Object)connection, new Object[0]);
                    logger.log(MLevel.FINEST, "endRequest method called");
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Error invoking endRequest method for connection", (Throwable)exception);
                }
            }
        }
    }

    private static class NoOpRequestBoundaryMarker
    implements RequestBoundaryMarker {
        private NoOpRequestBoundaryMarker() {
        }

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
        }
    }

    private static interface RequestBoundaryMarker {
        public void attemptNotifyBeginRequest(PooledConnection var1);

        public void attemptNotifyEndRequest(PooledConnection var1);
    }

    private static class C3P0PooledConnectionNestedLockLockFetcher
    implements InUseLockFetcher {
        private C3P0PooledConnectionNestedLockLockFetcher() {
        }

        @Override
        public Object getInUseLock(Object object) {
            return ((AbstractC3P0PooledConnection)object).inInternalUseLock;
        }
    }

    private static class ResourceItselfInUseLockFetcher
    implements InUseLockFetcher {
        private ResourceItselfInUseLockFetcher() {
        }

        @Override
        public Object getInUseLock(Object object) {
            return object;
        }
    }

    private static interface InUseLockFetcher {
        public Object getInUseLock(Object var1);
    }
}

