/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    static final MLogger logger = MLog.getLogger(WrapperConnectionPoolDataSource.class);
    Map userOverrides;

    public WrapperConnectionPoolDataSource(boolean bl) {
        block2: {
            super(bl);
            this.setUpPropertyListeners();
            try {
                this.setUserOverrides(C3P0ImplUtils.parseUserOverridesAsString(this.getUserOverridesAsString()));
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block2;
                logger.log(MLevel.WARNING, "Failed to parse stringified userOverrides. " + this.getUserOverridesAsString(), (Throwable)exception);
            }
        }
    }

    public WrapperConnectionPoolDataSource() {
        this(true);
    }

    private void setUpPropertyListeners() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if ("userOverridesAsString".equals(string)) {
                    try {
                        WrapperConnectionPoolDataSource.this.setUserOverrides(C3P0ImplUtils.parseUserOverridesAsString((String)object));
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "Failed to parse stringified userOverrides. " + object, (Throwable)exception);
                        }
                        throw new PropertyVetoException("Failed to parse stringified userOverrides. " + object, propertyChangeEvent);
                    }
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
    }

    public WrapperConnectionPoolDataSource(String string) {
        block3: {
            this();
            try {
                if (string != null) {
                    C3P0Config.bindNamedConfigToBean(this, string, true);
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "Error binding WrapperConnectionPoolDataSource to named-config '" + string + "'. Some default-config values may be used.", (Throwable)exception);
            }
        }
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection((ConnectionCustomizer)null, null);
    }

    @Override
    protected PooledConnection getPooledConnection(ConnectionCustomizer connectionCustomizer, String string) throws SQLException {
        DataSource dataSource = this.getNestedDataSource();
        if (dataSource == null) {
            throw new SQLException("No standard DataSource has been set beneath this wrapper! [ nestedDataSource == null ]");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (connection == null) {
                throw new SQLException("An (unpooled) DataSource returned null from its getConnection() method! DataSource: " + this.getNestedDataSource());
            }
            return new NewPooledConnection(connection, C3P0Registry.getConnectionTester(this.getConnectionTesterClassName(this.getUser())), this.getConnectionIsValidTimeout(this.getUser()), this.isAutoCommitOnClose(this.getUser()), this.isForceIgnoreUnresolvedTransactions(this.getUser()), this.getPreferredTestQuery(this.getUser()), connectionCustomizer, string);
        }
        catch (SQLException sQLException) {
            ConnectionUtils.attemptClose((Connection)connection);
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            ConnectionUtils.attemptClose((Connection)connection);
            throw runtimeException;
        }
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return this.getPooledConnection(string, string2, null, null);
    }

    @Override
    protected PooledConnection getPooledConnection(String string, String string2, ConnectionCustomizer connectionCustomizer, String string3) throws SQLException {
        DataSource dataSource = this.getNestedDataSource();
        if (dataSource == null) {
            throw new SQLException("No standard DataSource has been set beneath this wrapper! [ nestedDataSource == null ]");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection(string, string2);
            if (connection == null) {
                throw new SQLException("An (unpooled) DataSource returned null from its getConnection() method! DataSource: " + this.getNestedDataSource());
            }
            return new NewPooledConnection(connection, C3P0Registry.getConnectionTester(this.getConnectionTesterClassName(string)), this.getConnectionIsValidTimeout(string), this.isAutoCommitOnClose(string), this.isForceIgnoreUnresolvedTransactions(string), this.getPreferredTestQuery(string), connectionCustomizer, string3);
        }
        catch (SQLException sQLException) {
            ConnectionUtils.attemptClose(connection);
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            ConnectionUtils.attemptClose(connection);
            throw runtimeException;
        }
    }

    private synchronized int getConnectionIsValidTimeout(String string) {
        if (string == null) {
            return this.getConnectionIsValidTimeout();
        }
        Integer n = C3P0ConfigUtils.extractIntUserOverride("connectionIsValidTimeout", string, this.userOverrides);
        return n == null ? this.getConnectionIsValidTimeout() : n.intValue();
    }

    private synchronized boolean isAutoCommitOnClose(String string) {
        if (string == null) {
            return this.isAutoCommitOnClose();
        }
        Boolean bl = C3P0ConfigUtils.extractBooleanUserOverride("autoCommitOnClose", string, this.userOverrides);
        return bl == null ? this.isAutoCommitOnClose() : bl.booleanValue();
    }

    private synchronized boolean isForceIgnoreUnresolvedTransactions(String string) {
        if (string == null) {
            return this.isForceIgnoreUnresolvedTransactions();
        }
        Boolean bl = C3P0ConfigUtils.extractBooleanUserOverride("forceIgnoreUnresolvedTransactions", string, this.userOverrides);
        return bl == null ? this.isForceIgnoreUnresolvedTransactions() : bl.booleanValue();
    }

    private synchronized String getPreferredTestQuery(String string) {
        if (string == null) {
            return this.getPreferredTestQuery();
        }
        String string2 = (String)C3P0ConfigUtils.extractUserOverride("preferredTestQuery", string, this.userOverrides);
        return string2 == null ? this.getPreferredTestQuery() : string2;
    }

    private synchronized String getConnectionTesterClassName(String string) {
        if (string == null) {
            return this.getConnectionTesterClassName();
        }
        String string2 = (String)C3P0ConfigUtils.extractUserOverride("connectionTesterClassName", string, this.userOverrides);
        return string2 == null ? this.getConnectionTesterClassName() : string2;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.getNestedDataSource().setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(n);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'user' property from our nested DataSource. Defaulting to no specified username.", (Throwable)sQLException);
            }
            return null;
        }
    }

    public String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'password' property from our nested DataSource. Defaulting to no specified password.", (Throwable)sQLException);
            }
            return null;
        }
    }

    public synchronized Map getUserOverrides() {
        return this.userOverrides;
    }

    private synchronized void setUserOverrides(Map map) {
        this.userOverrides = map;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    @Override
    protected synchronized String extraToStringInfo() {
        if (this.userOverrides != null) {
            return "; userOverrides: " + this.userOverrides.toString();
        }
        return null;
    }
}

