/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.NoGoodResourcesException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEventSupport;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import com.mchange.v2.resourcepool.ResourcePoolUtils;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class BasicResourcePool
implements ResourcePool {
    private static final MLogger logger = MLog.getLogger(BasicResourcePool.class);
    static final int AUTO_CULL_FREQUENCY_DIVISOR = 4;
    static final int AUTO_MAX_CULL_FREQUENCY = 900000;
    static final int AUTO_MIN_CULL_FREQUENCY = 1000;
    final ReentrantLock lockMain = new ReentrantLock();
    final Condition conditionSomethingChanged = this.lockMain.newCondition();
    final ResourcePool.Manager mgr;
    final int start;
    final int min;
    final int max;
    final int inc;
    final int num_acq_attempts;
    final int acq_attempt_delay;
    final long check_idle_resources_delay;
    final long max_resource_age;
    final long max_idle_time;
    final long excess_max_idle_time;
    final long destroy_unreturned_resc_time;
    final long expiration_enforcement_delay;
    final boolean break_on_acquisition_failure;
    final boolean debug_store_checkout_exceptions;
    final boolean force_synchronous_checkins;
    final long pool_start_time = System.currentTimeMillis();
    final BasicResourcePoolFactory factory;
    final AsynchronousRunner taskRunner;
    final RunnableQueue asyncEventQueue;
    final ResourcePoolEventSupport rpes;
    Timer cullAndIdleRefurbishTimer;
    TimerTask cullTask;
    TimerTask idleRefurbishTask;
    HashSet acquireWaiters = new HashSet();
    HashSet otherWaiters = new HashSet();
    int pending_acquires;
    int pending_removes;
    int target_pool_size;
    HashMap managed = new HashMap();
    LinkedList unused = new LinkedList();
    HashSet excluded = new HashSet();
    Map formerResources = new WeakHashMap();
    Set idleCheckResources = new HashSet();
    boolean force_kill_acquires = false;
    boolean broken = false;
    long failed_checkins = 0L;
    long failed_checkouts = 0L;
    long failed_idle_tests = 0L;
    Throwable lastCheckinFailure = null;
    Throwable lastCheckoutFailure = null;
    Throwable lastIdleTestFailure = null;
    Throwable lastResourceTestFailure = null;
    Throwable lastAcquisitionFailiure = null;
    Object exampleResource;
    private static final int NO_DECREMENT = 0;
    private static final int DECREMENT_ON_SUCCESS = 1;
    private static final int DECREMENT_WITH_CERTAINTY = 2;

    void cscAwait() throws InterruptedException {
        this.conditionSomethingChanged.await();
    }

    void cscAwait(long l) throws InterruptedException {
        if (l > 0L) {
            this.conditionSomethingChanged.await(l, TimeUnit.MILLISECONDS);
        } else {
            this.conditionSomethingChanged.await();
        }
    }

    void cscSignalAll() {
        this.conditionSomethingChanged.signalAll();
    }

    @Override
    public long getStartTime() {
        return this.pool_start_time;
    }

    @Override
    public long getUpTime() {
        return System.currentTimeMillis() - this.pool_start_time;
    }

    @Override
    public long getNumFailedCheckins() {
        this.lockMain.lock();
        try {
            long l = this.failed_checkins;
            return l;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public long getNumFailedCheckouts() {
        this.lockMain.lock();
        try {
            long l = this.failed_checkouts;
            return l;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public long getNumFailedIdleTests() {
        this.lockMain.lock();
        try {
            long l = this.failed_idle_tests;
            return l;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public Throwable getLastCheckinFailure() {
        this.lockMain.lock();
        try {
            Throwable throwable = this.lastCheckinFailure;
            return throwable;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void setLastCheckinFailure(Throwable throwable) {
        assert (this.lockMain.isHeldByCurrentThread());
        this.lastCheckinFailure = throwable;
        this.lastResourceTestFailure = throwable;
    }

    @Override
    public Throwable getLastCheckoutFailure() {
        this.lockMain.lock();
        try {
            Throwable throwable = this.lastCheckoutFailure;
            return throwable;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void setLastCheckoutFailure(Throwable throwable) {
        assert (this.lockMain.isHeldByCurrentThread());
        this.lastCheckoutFailure = throwable;
        this.lastResourceTestFailure = throwable;
    }

    @Override
    public Throwable getLastIdleCheckFailure() {
        this.lockMain.lock();
        try {
            Throwable throwable = this.lastIdleTestFailure;
            return throwable;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void setLastIdleCheckFailure(Throwable throwable) {
        assert (this.lockMain.isHeldByCurrentThread());
        this.lastIdleTestFailure = throwable;
        this.lastResourceTestFailure = throwable;
    }

    @Override
    public Throwable getLastResourceTestFailure() {
        this.lockMain.lock();
        try {
            Throwable throwable = this.lastResourceTestFailure;
            return throwable;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public Throwable getLastAcquisitionFailure() {
        this.lockMain.lock();
        try {
            Throwable throwable = this.lastAcquisitionFailiure;
            return throwable;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void setLastAcquisitionFailure(Throwable throwable) {
        this.lockMain.lock();
        try {
            this.lastAcquisitionFailiure = throwable;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public int getNumCheckoutWaiters() {
        this.lockMain.lock();
        try {
            int n = this.acquireWaiters.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    public int getNumPendingAcquireTasks() {
        this.lockMain.lock();
        try {
            int n = this.pending_acquires;
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    public int getNumPendingRemoveTasks() {
        this.lockMain.lock();
        try {
            int n = this.pending_removes;
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    public int getNumThreadsWaitingForResources() {
        this.lockMain.lock();
        try {
            int n = this.acquireWaiters.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getThreadNamesWaitingForResources() {
        this.lockMain.lock();
        try {
            int n = this.acquireWaiters.size();
            Object[] objectArray = new String[n];
            int n2 = 0;
            Object[] objectArray2 = this.acquireWaiters.iterator();
            while (objectArray2.hasNext()) {
                objectArray[n2++] = ((Thread)objectArray2.next()).getName();
            }
            Arrays.sort(objectArray);
            objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    public int getNumThreadsWaitingForAdministrativeTasks() {
        this.lockMain.lock();
        try {
            int n = this.otherWaiters.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getThreadNamesWaitingForAdministrativeTasks() {
        this.lockMain.lock();
        try {
            int n = this.otherWaiters.size();
            Object[] objectArray = new String[n];
            int n2 = 0;
            Object[] objectArray2 = this.otherWaiters.iterator();
            while (objectArray2.hasNext()) {
                objectArray[n2++] = ((Thread)objectArray2.next()).getName();
            }
            Arrays.sort(objectArray);
            objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void addToFormerResources(Object object) {
        this.formerResources.put(object, null);
    }

    private boolean isFormerResource(Object object) {
        return this.formerResources.keySet().contains(object);
    }

    public BasicResourcePool(ResourcePool.Manager manager, int n, int n2, int n3, int n4, int n5, int n6, long l, long l2, long l3, long l4, long l5, long l6, boolean bl, boolean bl2, boolean bl3, AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer, BasicResourcePoolFactory basicResourcePoolFactory) throws ResourcePoolException {
        try {
            if (n2 > n3) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Bad pool size config, min " + n2 + " > max " + n3 + ". Using " + n3 + " as min.");
                }
                n2 = n3;
            }
            if (n < n2) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Bad pool size config, start " + n + " < min " + n2 + ". Using " + n2 + " as start.");
                }
                n = n2;
            }
            if (n > n3) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Bad pool size config, start " + n + " > max " + n3 + ". Using " + n3 + " as start.");
                }
                n = n3;
            }
            this.mgr = manager;
            this.start = n;
            this.min = n2;
            this.max = n3;
            this.inc = n4;
            this.num_acq_attempts = n5;
            this.acq_attempt_delay = n6;
            this.check_idle_resources_delay = l;
            this.max_resource_age = l2;
            this.max_idle_time = l3;
            this.excess_max_idle_time = l4;
            this.destroy_unreturned_resc_time = l5;
            this.break_on_acquisition_failure = bl;
            this.debug_store_checkout_exceptions = bl2 && l5 > 0L;
            this.force_synchronous_checkins = bl3;
            this.taskRunner = asynchronousRunner;
            this.asyncEventQueue = runnableQueue;
            this.cullAndIdleRefurbishTimer = timer;
            this.factory = basicResourcePoolFactory;
            this.pending_acquires = 0;
            this.pending_removes = 0;
            this.target_pool_size = this.start;
            this.rpes = runnableQueue != null ? new ResourcePoolEventSupport(this) : null;
            this.ensureStartResources();
            if (this.mustEnforceExpiration()) {
                this.expiration_enforcement_delay = l6 <= 0L ? this.automaticExpirationEnforcementDelay() : l6;
                this.cullTask = new CullTask();
                timer.schedule(this.cullTask, this.minExpirationTime(), this.expiration_enforcement_delay);
            } else {
                this.expiration_enforcement_delay = l6;
            }
            if (l > 0L) {
                this.idleRefurbishTask = new CheckIdleResourcesTask();
                timer.schedule(this.idleRefurbishTask, l, l);
            }
            if (logger.isLoggable(MLevel.FINER)) {
                logger.finer(this + " config: [start -> " + this.start + "; min -> " + this.min + "; max -> " + this.max + "; inc -> " + this.inc + "; num_acq_attempts -> " + this.num_acq_attempts + "; acq_attempt_delay -> " + this.acq_attempt_delay + "; check_idle_resources_delay -> " + this.check_idle_resources_delay + "; max_resource_age -> " + this.max_resource_age + "; max_idle_time -> " + this.max_idle_time + "; excess_max_idle_time -> " + this.excess_max_idle_time + "; destroy_unreturned_resc_time -> " + this.destroy_unreturned_resc_time + "; expiration_enforcement_delay -> " + this.expiration_enforcement_delay + "; break_on_acquisition_failure -> " + this.break_on_acquisition_failure + "; debug_store_checkout_exceptions -> " + this.debug_store_checkout_exceptions + "; force_synchronous_checkins -> " + this.force_synchronous_checkins + "]");
            }
        }
        catch (Exception exception) {
            throw ResourcePoolUtils.convertThrowable(exception);
        }
    }

    private boolean mustTestIdleResources() {
        return this.check_idle_resources_delay > 0L;
    }

    private boolean mustEnforceExpiration() {
        return this.max_resource_age > 0L || this.max_idle_time > 0L || this.excess_max_idle_time > 0L || this.destroy_unreturned_resc_time > 0L;
    }

    private long minExpirationTime() {
        long l = Long.MAX_VALUE;
        if (this.max_resource_age > 0L) {
            l = Math.min(l, this.max_resource_age);
        }
        if (this.max_idle_time > 0L) {
            l = Math.min(l, this.max_idle_time);
        }
        if (this.excess_max_idle_time > 0L) {
            l = Math.min(l, this.excess_max_idle_time);
        }
        if (this.destroy_unreturned_resc_time > 0L) {
            l = Math.min(l, this.destroy_unreturned_resc_time);
        }
        return l;
    }

    private long automaticExpirationEnforcementDelay() {
        long l = this.minExpirationTime();
        l /= 4L;
        l = Math.min(l, 900000L);
        l = Math.max(l, 1000L);
        return l;
    }

    @Override
    public long getEffectiveExpirationEnforcementDelay() {
        return this.expiration_enforcement_delay;
    }

    private boolean isBroken() {
        this.lockMain.lock();
        try {
            boolean bl = this.broken;
            return bl;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private boolean supportsEvents() {
        return this.asyncEventQueue != null;
    }

    @Override
    public Object checkoutResource() throws ResourcePoolException, InterruptedException {
        try {
            return this.checkoutResource(0L);
        }
        catch (TimeoutException timeoutException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Huh??? TimeoutException with no timeout set!!!", (Throwable)((Object)timeoutException));
            }
            throw new ResourcePoolException("Huh??? TimeoutException with no timeout set!!!", (Throwable)((Object)timeoutException));
        }
    }

    private void _recheckResizePool() {
        assert (this.lockMain.isHeldByCurrentThread());
        if (!this.broken) {
            int n = this.managed.size();
            int n2 = n - this.pending_removes - this.target_pool_size;
            if (n2 > 0) {
                this.shrinkPool(n2);
            } else {
                int n3 = this.target_pool_size - (n + this.pending_acquires);
                if (n3 > 0) {
                    this.expandPool(n3);
                }
            }
        }
    }

    private void incrementPendingAcquires() {
        this.lockMain.lock();
        try {
            ++this.pending_acquires;
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("incremented pending_acquires: " + this.pending_acquires);
            }
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void incrementPendingRemoves() {
        this.lockMain.lock();
        try {
            ++this.pending_removes;
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("incremented pending_removes: " + this.pending_removes);
            }
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void decrementPendingAcquires() {
        this.lockMain.lock();
        try {
            this._decrementPendingAcquires();
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void _decrementPendingAcquires() {
        --this.pending_acquires;
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("decremented pending_acquires: " + this.pending_acquires);
        }
    }

    private void decrementPendingRemoves() {
        this.lockMain.lock();
        try {
            --this.pending_removes;
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("decremented pending_removes: " + this.pending_removes);
            }
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void recheckResizePool() {
        this.lockMain.lock();
        try {
            this._recheckResizePool();
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void expandPool(int n) {
        assert (this.lockMain.isHeldByCurrentThread());
        for (int i = 0; i < n; ++i) {
            this.taskRunner.postRunnable((Runnable)new ScatteredAcquireTask());
        }
    }

    private void shrinkPool(int n) {
        assert (this.lockMain.isHeldByCurrentThread());
        for (int i = 0; i < n; ++i) {
            this.taskRunner.postRunnable((Runnable)new RemoveTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object checkoutResource(long l) throws TimeoutException, ResourcePoolException, InterruptedException {
        try {
            Object object = this.prelimCheckoutResource(l);
            boolean bl = this.attemptRefurbishResourceOnCheckout(object);
            this.lockMain.lock();
            try {
                if (!bl) {
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "Resource [" + object + "] could not be refurbished in preparation for checkout. Will try to find a better resource.");
                    }
                    this.removeResource(object);
                    this.ensureMinResources();
                    object = null;
                } else {
                    this.asyncFireResourceCheckedOut(object, this.managed.size(), this.unused.size(), this.excluded.size());
                    this.trace();
                    PunchCard punchCard = (PunchCard)this.managed.get(object);
                    if (punchCard == null) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.finer("Resource " + object + " was removed from the pool while it was being checked out  or refurbished for checkout. Will try to find a replacement resource.");
                        }
                        object = null;
                    } else {
                        punchCard.checkout_time = System.currentTimeMillis();
                        if (this.debug_store_checkout_exceptions) {
                            punchCard.checkoutStackTraceException = new Exception("DEBUG STACK TRACE: Overdue resource check-out stack trace.");
                        }
                    }
                }
            }
            finally {
                this.lockMain.unlock();
            }
            if (object == null) {
                return this.checkoutResource(l);
            }
            return object;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new NoGoodResourcesException("After checking so many resources we blew the stack, no resources tested acceptable for checkout. See logger com.mchange.v2.resourcepool.BasicResourcePool output at FINER/DEBUG for information on individual failures.", stackOverflowError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object prelimCheckoutResource(long l) throws TimeoutException, ResourcePoolException, InterruptedException {
        this.lockMain.lock();
        try {
            int n;
            this.ensureNotBroken();
            while ((n = this.unused.size()) == 0) {
                int n2 = this.managed.size();
                if (n2 < this.max) {
                    int n3 = n2 + this.acquireWaiters.size() + 1;
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "acquire test -- pool size: " + n2 + "; target_pool_size: " + this.target_pool_size + "; desired target? " + n3);
                    }
                    if (n3 >= this.target_pool_size) {
                        n3 = Math.max(n3, this.target_pool_size + this.inc);
                        this.target_pool_size = Math.max(Math.min(this.max, n3), this.min);
                        this._recheckResizePool();
                    }
                } else if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "acquire test -- pool is already maxed out. [managed: " + n2 + "; max: " + this.max + "]");
                }
                this.awaitAvailable(l);
            }
            Object e = this.unused.get(0);
            if (this.idleCheckResources.contains(e)) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Resource we want to check out is in idleCheck! (waiting until idle-check completes.) [" + this + "]");
                }
                Thread thread = Thread.currentThread();
                try {
                    this.otherWaiters.add(thread);
                    this.cscAwait(l);
                    this.ensureNotBroken();
                }
                finally {
                    this.otherWaiters.remove(thread);
                }
                Object object = this.prelimCheckoutResource(l);
                return object;
            }
            if (this.shouldExpire(e)) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Resource we want to check out has expired already. Trying again.");
                }
                this.removeResource(e);
                this.ensureMinResources();
                Object object = this.prelimCheckoutResource(l);
                return object;
            }
            this.unused.remove(0);
            Object e2 = e;
            return e2;
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " -- the pool was found to be closed or broken during an attempt to check out a resource.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
        catch (InterruptedException interruptedException) {
            if (this.broken) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. [Thread: " + Thread.currentThread().getName() + ']', (Throwable)interruptedException);
                } else if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. [Thread: " + Thread.currentThread().getName() + ']');
                }
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, this + " -- an attempt to checkout a resource was interrupted, and the pool is still live: some other thread must have interrupted the Thread attempting checkout!", (Throwable)interruptedException);
            }
            throw interruptedException;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new NoGoodResourcesException("After checking so many resources we blew the stack, no resources tested acceptable for checkout. See logger com.mchange.v2.resourcepool.BasicResourcePool output at FINER/DEBUG for information on individual failures.", stackOverflowError);
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public void checkinResource(Object object) throws ResourcePoolException {
        try {
            boolean bl;
            block11: {
                bl = false;
                this.lockMain.lock();
                try {
                    if (this.managed.keySet().contains(object)) {
                        bl = true;
                        break block11;
                    }
                    if (this.excluded.contains(object)) {
                        this.doCheckinExcluded(object);
                        break block11;
                    }
                    if (this.isFormerResource(object)) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.finer("Resource " + object + " checked-in after having been checked-in already, or checked-in after  having being destroyed for being checked-out too long.");
                        }
                        break block11;
                    }
                    throw new ResourcePoolException("ResourcePool" + (this.broken ? " [BROKEN!]" : "") + ": Tried to check-in a foreign resource!");
                }
                finally {
                    this.lockMain.unlock();
                }
            }
            if (bl) {
                this.doCheckinManaged(object);
            }
            this.syncTrace();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinResource( ... ) -- even broken pools should allow checkins without exception. probable resource pool bug.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    @Override
    public void checkinAll() throws ResourcePoolException {
        try {
            Iterator iterator;
            HashSet hashSet = null;
            this.lockMain.lock();
            try {
                hashSet = new HashSet(this.managed.keySet());
                hashSet.removeAll(this.unused);
                iterator = this.excluded.iterator();
                while (iterator.hasNext()) {
                    this.doCheckinExcluded(iterator.next());
                }
            }
            finally {
                this.lockMain.unlock();
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.doCheckinManaged(iterator.next());
            }
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinAll() -- even broken pools should allow checkins without exception. probable resource pool bug.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    @Override
    public int statusInPool(Object object) throws ResourcePoolException {
        this.lockMain.lock();
        try {
            if (this.unused.contains(object)) {
                int n = 0;
                return n;
            }
            if (this.managed.keySet().contains(object) || this.excluded.contains(object)) {
                int n = 1;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public void markBroken(Object object) {
        this.lockMain.lock();
        try {
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Resource " + object + " marked broken by pool (" + this + ").");
            }
            this._markBroken(object);
            this.ensureMinResources();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public int getMinPoolSize() {
        return this.min;
    }

    @Override
    public int getMaxPoolSize() {
        return this.max;
    }

    @Override
    public int getPoolSize() throws ResourcePoolException {
        this.lockMain.lock();
        try {
            int n = this.managed.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public int getAvailableCount() {
        this.lockMain.lock();
        try {
            int n = this.unused.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public int getExcludedCount() {
        this.lockMain.lock();
        try {
            int n = this.excluded.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public int getAwaitingCheckinCount() {
        this.lockMain.lock();
        try {
            int n = this.managed.size() - this.unused.size() + this.excluded.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public int getAwaitingCheckinNotExcludedCount() {
        this.lockMain.lock();
        try {
            int n = this.managed.size() - this.unused.size();
            return n;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public void resetPool() {
        this.lockMain.lock();
        try {
            Iterator iterator = this.cloneOfManaged().keySet().iterator();
            while (iterator.hasNext()) {
                this.markBrokenNoEnsureMinResources(iterator.next());
            }
            this.ensureMinResources();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
        }
        finally {
            this.lockMain.unlock();
        }
    }

    @Override
    public void close() throws ResourcePoolException {
        this.lockMain.lock();
        try {
            this.close(true);
        }
        finally {
            this.lockMain.unlock();
        }
    }

    public void finalize() throws Throwable {
        if (!this.broken) {
            this.close();
        }
    }

    public void addResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        if (!this.supportsEvents()) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.addResourcePoolListener(resourcePoolListener);
    }

    public void removeResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        if (!this.supportsEvents()) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.removeResourcePoolListener(resourcePoolListener);
    }

    private boolean isForceKillAcquiresPending() {
        this.lockMain.lock();
        try {
            boolean bl = this.force_kill_acquires;
            return bl;
        }
        finally {
            this.lockMain.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceKillAcquires() throws InterruptedException {
        this.lockMain.lock();
        try {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Having failed to acquire a resource, " + this + " is interrupting all Threads waiting on a resource to check out. Will try again in response to new client requests.");
            }
            Thread thread = Thread.currentThread();
            try {
                this.force_kill_acquires = true;
                this.cscSignalAll();
                while (this.acquireWaiters.size() > 0) {
                    this.otherWaiters.add(thread);
                    this.cscAwait();
                }
                this.force_kill_acquires = false;
            }
            catch (InterruptedException interruptedException) {
                Iterator iterator = this.acquireWaiters.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "An interrupt left an attempt to gently clear threads waiting on resource acquisition potentially incomplete! We have made a best attempt to finish that by interrupt()ing the waiting Threads.");
                }
                this.force_kill_acquires = false;
                interruptedException.fillInStackTrace();
                throw interruptedException;
            }
            catch (Throwable throwable) {
                Iterator iterator = this.acquireWaiters.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
                if (logger.isLoggable(MLevel.SEVERE)) {
                    logger.log(MLevel.SEVERE, "An unexpected problem caused our attempt to gently clear threads waiting on resource acquisition to fail! We have made a best attempt to finish that by interrupt()ing the waiting Threads.", throwable);
                }
                this.force_kill_acquires = false;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException("Wrapped unexpected Throwable.", throwable);
            }
            finally {
                this.otherWaiters.remove(thread);
            }
        }
        finally {
            this.lockMain.lock();
        }
    }

    private void unexpectedBreak() {
        this.lockMain.lock();
        try {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " -- Unexpectedly broken!!!", (Throwable)((Object)new ResourcePoolException("Unexpected Break Stack Trace!")));
            }
            this.close(false);
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private boolean canFireEvents() {
        return this.asyncEventQueue != null && !this.isBroken();
    }

    private void asyncFireResourceAcquired(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceAcquired(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceCheckedIn(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedIn(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceCheckedOut(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedOut(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceRemoved(final Object object, final boolean bl, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceRemoved(object, bl, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void destroyResource(Object object) {
        this.destroyResource(object, false);
    }

    private void destroyResource(Object object, boolean bl) {
        this.destroyResource(object, bl, false);
    }

    private void destroyResource(final Object object, boolean bl, final boolean bl2) {
        class DestroyResourceTask
        implements Runnable {
            DestroyResourceTask() {
            }

            @Override
            public void run() {
                block4: {
                    try {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Preparing to destroy resource: " + object);
                        }
                        BasicResourcePool.this.mgr.destroyResource(object, bl2);
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Successfully destroyed resource: " + object);
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block4;
                        logger.log(MLevel.WARNING, "Failed to destroy resource: " + object, (Throwable)exception);
                    }
                }
            }
        }
        DestroyResourceTask destroyResourceTask = new DestroyResourceTask();
        if (bl || this.broken) {
            if (logger.isLoggable(MLevel.FINEST) && !this.broken && this.lockMain.isHeldByCurrentThread()) {
                logger.log(MLevel.FINEST, this + ": Destroying a resource on an active pool, synchronousy while holding pool's lock! (not a bug, but a potential bottleneck... is there a good reason for this?)", (Throwable)new Exception("DEBUG STACK TRACE: resource destruction while holding lock."));
            }
            destroyResourceTask.run();
        } else {
            try {
                this.taskRunner.postRunnable((Runnable)destroyResourceTask);
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "AsynchronousRunner refused to accept task to destroy resource. It is probably shared, and has probably been closed underneath us. Reverting to synchronous destruction. This is not usually a problem.", (Throwable)exception);
                }
                this.destroyResource(object, true);
            }
        }
    }

    private void doAcquire() throws Exception {
        this.doAcquire(0);
    }

    private void doAcquireAndDecrementPendingAcquiresWithinLockOnSuccess() throws Exception {
        this.doAcquire(1);
    }

    private void doAcquireAndDecrementPendingAcquiresWithinLockAlways() throws Exception {
        this.doAcquire(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAcquire(int n) throws Exception {
        block16: {
            assert (!this.lockMain.isHeldByCurrentThread());
            Object object = this.mgr.acquireResource();
            boolean bl = false;
            this.lockMain.lock();
            try {
                try {
                    int n2 = this.managed.size();
                    if (!this.broken && n2 < this.target_pool_size) {
                        this.assimilateResource(object);
                    } else {
                        bl = true;
                    }
                    if (n == 1) {
                        this._decrementPendingAcquires();
                    }
                }
                finally {
                    if (n == 2) {
                        this._decrementPendingAcquires();
                    }
                }
            }
            finally {
                this.lockMain.unlock();
            }
            if (bl) {
                try {
                    this.mgr.destroyResource(object, false);
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "destroying overacquired resource: " + object);
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.FINE)) break block16;
                    logger.log(MLevel.FINE, "An exception occurred while trying to destroy an overacquired resource: " + object, (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void setPoolSize(int n) throws ResourcePoolException {
        this.lockMain.lock();
        try {
            this.setTargetPoolSize(n);
            while (this.managed.size() != n) {
                this.cscAwait();
            }
        }
        catch (Exception exception) {
            String string = "An exception occurred while trying to set the pool size!";
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, string, (Throwable)exception);
            }
            throw ResourcePoolUtils.convertThrowable(string, exception);
        }
        finally {
            this.lockMain.unlock();
        }
    }

    public void setTargetPoolSize(int n) {
        this.lockMain.lock();
        try {
            if (n > this.max) {
                throw new IllegalArgumentException("Requested size [" + n + "] is greater than max [" + this.max + "].");
            }
            if (n < this.min) {
                throw new IllegalArgumentException("Requested size [" + n + "] is less than min [" + this.min + "].");
            }
            this.target_pool_size = n;
            this._recheckResizePool();
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void markBrokenNoEnsureMinResources(Object object) {
        assert (this.lockMain.isHeldByCurrentThread());
        try {
            this._markBroken(object);
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    private void _markBroken(Object object) {
        assert (this.lockMain.isHeldByCurrentThread());
        if (this.unused.contains(object)) {
            this.removeResource(object);
        } else {
            this.excludeResource(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean bl) {
        this.lockMain.lock();
        try {
            if (!this.broken) {
                Collection<Object> collection;
                this.broken = true;
                Collection<Object> collection2 = collection = bl ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
                if (this.cullTask != null) {
                    this.cullTask.cancel();
                }
                if (this.idleRefurbishTask != null) {
                    this.idleRefurbishTask.cancel();
                }
                Object object = collection.iterator();
                while (object.hasNext()) {
                    this.addToFormerResources(object.next());
                }
                this.managed.keySet().removeAll(collection);
                this.unused.removeAll(collection);
                object = new Thread("Resource Destroyer in BasicResourcePool.close()"){

                    @Override
                    public void run() {
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            try {
                                Object e = iterator.next();
                                BasicResourcePool.this.destroyResource(e, true);
                            }
                            catch (Exception exception) {
                                if (!logger.isLoggable(MLevel.FINE)) continue;
                                logger.log(MLevel.FINE, "BasicResourcePool -- A resource couldn't be cleaned up on close()", (Throwable)exception);
                            }
                        }
                    }
                };
                ((Thread)object).start();
                Iterator iterator = this.acquireWaiters.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
                iterator = this.otherWaiters.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
                if (this.factory != null) {
                    this.factory.markBroken(this);
                }
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning(this + " -- close() called multiple times.");
            }
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void doCheckinManaged(final Object object) throws ResourcePoolException {
        assert (!this.lockMain.isHeldByCurrentThread());
        if (this.statusInPool(object) == 0) {
            throw new ResourcePoolException("Tried to check-in an already checked-in resource: " + object);
        }
        this.lockMain.lock();
        try {
            if (this.broken) {
                this.removeResource(object, true);
                return;
            }
        }
        finally {
            this.lockMain.unlock();
        }
        class RefurbishCheckinResourceTask
        implements Runnable {
            RefurbishCheckinResourceTask() {
            }

            @Override
            public void run() {
                boolean bl = BasicResourcePool.this.attemptRefurbishResourceOnCheckin(object);
                BasicResourcePool.this.lockMain.lock();
                try {
                    PunchCard punchCard = (PunchCard)BasicResourcePool.this.managed.get(object);
                    if (bl && punchCard != null) {
                        BasicResourcePool.this.unused.add(0, object);
                        punchCard.last_checkin_time = System.currentTimeMillis();
                        punchCard.checkout_time = -1L;
                    } else {
                        if (punchCard != null) {
                            punchCard.checkout_time = -1L;
                        }
                        BasicResourcePool.this.removeResource(object);
                        BasicResourcePool.this.ensureMinResources();
                        if (punchCard == null && logger.isLoggable(MLevel.FINE)) {
                            logger.fine("Resource " + object + " was removed from the pool during its refurbishment for checkin.");
                        }
                    }
                    BasicResourcePool.this.asyncFireResourceCheckedIn(object, BasicResourcePool.this.managed.size(), BasicResourcePool.this.unused.size(), BasicResourcePool.this.excluded.size());
                    BasicResourcePool.this.cscSignalAll();
                }
                finally {
                    BasicResourcePool.this.lockMain.unlock();
                }
            }
        }
        RefurbishCheckinResourceTask refurbishCheckinResourceTask = new RefurbishCheckinResourceTask();
        if (this.force_synchronous_checkins) {
            refurbishCheckinResourceTask.run();
        } else {
            this.taskRunner.postRunnable((Runnable)refurbishCheckinResourceTask);
        }
    }

    private void doCheckinExcluded(Object object) {
        assert (this.lockMain.isHeldByCurrentThread());
        this.excluded.remove(object);
        this.destroyResource(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAvailable(long l) throws InterruptedException, TimeoutException, ResourcePoolException {
        assert (this.lockMain.isHeldByCurrentThread());
        if (this.force_kill_acquires) {
            throw new ResourcePoolException("A ResourcePool cannot acquire a new resource -- the factory or source appears to be down.");
        }
        Thread thread = Thread.currentThread();
        try {
            int n;
            long l2;
            this.acquireWaiters.add(thread);
            long l3 = l2 = l > 0L ? System.currentTimeMillis() : -1L;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("awaitAvailable(): " + (this.exampleResource != null ? this.exampleResource : "[unknown]"));
            }
            this.trace();
            long l4 = l;
            while ((n = this.unused.size()) == 0) {
                if (this.pending_acquires == 0 && this.managed.size() < this.max) {
                    this._recheckResizePool();
                }
                this.cscAwait(l4);
                l4 = Math.max(0L, l - (System.currentTimeMillis() - l2));
                if (l > 0L && l4 == 0L) {
                    throw new TimeoutException("A client timed out while waiting to acquire a resource from " + this + " -- timeout at awaitAvailable()");
                }
                if (this.force_kill_acquires) {
                    throw new CannotAcquireResourceException("A ResourcePool could not acquire a resource from its primary factory or source.", this.getLastAcquisitionFailure());
                }
                this.ensureNotBroken();
            }
        }
        finally {
            this.acquireWaiters.remove(thread);
            if (this.acquireWaiters.size() == 0) {
                this.cscSignalAll();
            }
        }
    }

    private void assimilateResource(Object object) throws Exception {
        assert (this.lockMain.isHeldByCurrentThread());
        this.managed.put(object, new PunchCard());
        this.unused.add(0, object);
        this.asyncFireResourceAcquired(object, this.managed.size(), this.unused.size(), this.excluded.size());
        this.cscSignalAll();
        this.trace();
        if (this.exampleResource == null) {
            this.exampleResource = object;
        }
    }

    private void synchronousRemoveArbitraryResource() {
        assert (!this.lockMain.isHeldByCurrentThread());
        Object var1_1 = null;
        this.lockMain.lock();
        try {
            if (this.unused.size() > 0) {
                var1_1 = this.unused.get(0);
                this.managed.remove(var1_1);
                this.unused.remove(var1_1);
            } else {
                Set set = this.cloneOfManaged().keySet();
                if (set.isEmpty()) {
                    this.unexpectedBreak();
                    logger.severe("A pool from which a resource is requested to be removed appears to have no managed resources?!");
                } else {
                    this.excludeResource(set.iterator().next());
                }
            }
        }
        finally {
            this.lockMain.unlock();
        }
        if (var1_1 != null) {
            this.destroyResource(var1_1, true);
        }
    }

    private void removeResource(Object object) {
        this.removeResource(object, false);
    }

    private void removeResource(Object object, boolean bl) {
        assert (this.lockMain.isHeldByCurrentThread());
        PunchCard punchCard = (PunchCard)this.managed.remove(object);
        boolean bl2 = false;
        if (punchCard != null) {
            boolean bl3 = bl2 = punchCard.checkout_time > 0L;
            if (bl2 && !this.broken && logger.isLoggable(MLevel.INFO)) {
                logger.info("A checked-out resource is overdue, and will be destroyed: " + object);
                if (punchCard.checkoutStackTraceException != null) {
                    logger.log(MLevel.INFO, "Logging the stack trace by which the overdue resource was checked-out.", (Throwable)punchCard.checkoutStackTraceException);
                }
            }
        } else if (logger.isLoggable(MLevel.FINE)) {
            logger.fine("Resource " + object + " was removed twice. (Lotsa reasons a resource can be removed, sometimes simultaneously. It's okay)");
        }
        this.unused.remove(object);
        this.destroyResource(object, bl, bl2);
        this.addToFormerResources(object);
        this.asyncFireResourceRemoved(object, false, this.managed.size(), this.unused.size(), this.excluded.size());
        this.trace();
    }

    private void excludeResource(Object object) {
        assert (this.lockMain.isHeldByCurrentThread());
        this.managed.remove(object);
        this.excluded.add(object);
        if (this.unused.contains(object)) {
            throw new InternalError("We should only \"exclude\" checked-out resources!");
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, "Excluded resource " + object, (Throwable)new Exception("DEBUG STACK TRACE: Excluded resource stack trace"));
        }
        this.asyncFireResourceRemoved(object, true, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void removeTowards(int n) {
        assert (this.lockMain.isHeldByCurrentThread());
        int n2 = this.managed.size() - n;
        Iterator iterator = this.cloneOfUnused().iterator();
        for (int i = 0; iterator.hasNext() && i < n2; ++i) {
            Object e = iterator.next();
            this.removeResource(e);
        }
    }

    private void cullExpired() {
        assert (this.lockMain.isHeldByCurrentThread());
        if (logger.isLoggable(MLevel.FINER)) {
            logger.log(MLevel.FINER, "BEGIN check for expired resources.  [" + this + "]");
        }
        Collection<Object> collection = this.destroy_unreturned_resc_time > 0L ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
        for (Object object : collection) {
            if (!this.shouldExpire(object)) continue;
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Removing expired resource: " + object + " [" + this + "]");
            }
            this.target_pool_size = Math.max(this.min, this.target_pool_size - 1);
            this.removeResource(object);
            this.trace();
        }
        if (logger.isLoggable(MLevel.FINER)) {
            logger.log(MLevel.FINER, "FINISHED check for expired resources.  [" + this + "]");
        }
        this.ensureMinResources();
    }

    private void checkIdleResources() {
        assert (this.lockMain.isHeldByCurrentThread());
        LinkedList linkedList = this.cloneOfUnused();
        for (Object e : linkedList) {
            if (!this.idleCheckResources.add(e)) continue;
            this.taskRunner.postRunnable((Runnable)new AsyncTestIdleResourceTask(e));
        }
        this.trace();
    }

    private boolean shouldExpire(Object object) {
        assert (this.lockMain.isHeldByCurrentThread());
        boolean bl = false;
        PunchCard punchCard = (PunchCard)this.managed.get(object);
        if (punchCard == null) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("Resource " + object + " was being tested for expiration, but has already been removed from the pool.");
            }
            return true;
        }
        long l = System.currentTimeMillis();
        if (punchCard.checkout_time < 0L) {
            long l2 = l - punchCard.last_checkin_time;
            if (this.excess_max_idle_time > 0L) {
                int n = this.managed.size();
                boolean bl2 = bl = n > this.min && l2 > this.excess_max_idle_time;
                if (bl && logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "EXPIRED excess idle resource: " + object + " ---> idle_time: " + l2 + "; excess_max_idle_time: " + this.excess_max_idle_time + "; pool_size: " + n + "; min_pool_size: " + this.min + " [" + this + "]");
                }
            }
            if (!bl && this.max_idle_time > 0L) {
                boolean bl3 = bl = l2 > this.max_idle_time;
                if (bl && logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "EXPIRED idle resource: " + object + " ---> idle_time: " + l2 + "; max_idle_time: " + this.max_idle_time + " [" + this + "]");
                }
            }
            if (!bl && this.max_resource_age > 0L) {
                long l3 = l - punchCard.acquisition_time;
                boolean bl4 = bl = l3 > this.max_resource_age;
                if (bl && logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "EXPIRED old resource: " + object + " ---> absolute_age: " + l3 + "; max_absolute_age: " + this.max_resource_age + " [" + this + "]");
                }
            }
        } else {
            long l4 = l - punchCard.checkout_time;
            bl = l4 > this.destroy_unreturned_resc_time;
        }
        return bl;
    }

    private void ensureStartResources() {
        this.recheckResizePool();
    }

    private void ensureMinResources() {
        this.recheckResizePool();
    }

    private boolean attemptRefurbishResourceOnCheckout(Object object) {
        assert (!this.lockMain.isHeldByCurrentThread());
        try {
            this.mgr.refurbishResourceOnCheckout(object);
            return true;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished for checkout. [" + object + ']', (Throwable)exception);
            }
            this.lockMain.lock();
            try {
                ++this.failed_checkouts;
                this.setLastCheckoutFailure(exception);
            }
            finally {
                this.lockMain.unlock();
            }
            return false;
        }
    }

    private boolean attemptRefurbishResourceOnCheckin(Object object) {
        assert (!this.lockMain.isHeldByCurrentThread());
        try {
            this.mgr.refurbishResourceOnCheckin(object);
            return true;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished on checkin. [" + object + ']', (Throwable)exception);
            }
            this.lockMain.lock();
            try {
                ++this.failed_checkins;
                this.setLastCheckinFailure(exception);
            }
            finally {
                this.lockMain.unlock();
            }
            return false;
        }
    }

    private void ensureNotBroken() throws ResourcePoolException {
        assert (this.lockMain.isHeldByCurrentThread());
        if (this.broken) {
            throw new ResourcePoolException("Attempted to use a closed or broken resource pool");
        }
    }

    private void syncTrace() {
        this.lockMain.lock();
        try {
            this.trace();
        }
        finally {
            this.lockMain.unlock();
        }
    }

    private void trace() {
        assert (this.lockMain.isHeldByCurrentThread());
        if (logger.isLoggable(MLevel.FINEST)) {
            String string = this.exampleResource == null ? "" : " (e.g. " + this.exampleResource + ")";
            logger.finest("trace " + this + " [managed: " + this.managed.size() + ", unused: " + this.unused.size() + ", excluded: " + this.excluded.size() + ']' + string);
        }
    }

    private final HashMap cloneOfManaged() {
        assert (this.lockMain.isHeldByCurrentThread());
        return (HashMap)this.managed.clone();
    }

    private final LinkedList cloneOfUnused() {
        assert (this.lockMain.isHeldByCurrentThread());
        return (LinkedList)this.unused.clone();
    }

    private final HashSet cloneOfExcluded() {
        assert (this.lockMain.isHeldByCurrentThread());
        return (HashSet)this.excluded.clone();
    }

    static final class PunchCard {
        long acquisition_time;
        long last_checkin_time;
        long checkout_time;
        Exception checkoutStackTraceException;

        PunchCard() {
            this.last_checkin_time = this.acquisition_time = System.currentTimeMillis();
            this.checkout_time = -1L;
            this.checkoutStackTraceException = null;
        }
    }

    class AsyncTestIdleResourceTask
    implements Runnable {
        Object resc;
        boolean pending = true;
        boolean failed;

        AsyncTestIdleResourceTask(Object object) {
            this.resc = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!BasicResourcePool.this.lockMain.isHeldByCurrentThread());
            try {
                try {
                    BasicResourcePool.this.mgr.refurbishIdleResource(this.resc);
                }
                catch (Exception exception) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "BasicResourcePool: An idle resource is broken and will be purged. [" + this.resc + ']', (Throwable)exception);
                    }
                    BasicResourcePool.this.lockMain.lock();
                    try {
                        if (BasicResourcePool.this.managed.keySet().contains(this.resc)) {
                            BasicResourcePool.this.removeResource(this.resc);
                            BasicResourcePool.this.ensureMinResources();
                        }
                        ++BasicResourcePool.this.failed_idle_tests;
                        BasicResourcePool.this.setLastIdleCheckFailure(exception);
                    }
                    finally {
                        BasicResourcePool.this.lockMain.unlock();
                    }
                }
            }
            finally {
                BasicResourcePool.this.lockMain.lock();
                try {
                    BasicResourcePool.this.idleCheckResources.remove(this.resc);
                    BasicResourcePool.this.cscSignalAll();
                }
                finally {
                    BasicResourcePool.this.lockMain.unlock();
                }
            }
        }
    }

    class CheckIdleResourcesTask
    extends TimerTask {
        CheckIdleResourcesTask() {
        }

        @Override
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Refurbishing idle resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool.this.lockMain.lock();
                try {
                    BasicResourcePool.this.checkIdleResources();
                }
                finally {
                    BasicResourcePool.this.lockMain.unlock();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", (Throwable)resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class CullTask
    extends TimerTask {
        CullTask() {
        }

        @Override
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Checking for expired resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool.this.lockMain.lock();
                try {
                    BasicResourcePool.this.cullExpired();
                }
                finally {
                    BasicResourcePool.this.lockMain.unlock();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", (Throwable)resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class RemoveTask
    implements Runnable {
        public RemoveTask() {
            BasicResourcePool.this.incrementPendingRemoves();
        }

        @Override
        public void run() {
            try {
                BasicResourcePool.this.synchronousRemoveArbitraryResource();
                BasicResourcePool.this.recheckResizePool();
            }
            finally {
                BasicResourcePool.this.decrementPendingRemoves();
            }
        }
    }

    class ScatteredAcquireTask
    implements Runnable {
        int attempts_remaining;

        ScatteredAcquireTask() {
            this(basicResourcePool.num_acq_attempts >= 0 ? basicResourcePool.num_acq_attempts : -1, true);
        }

        private ScatteredAcquireTask(int n, boolean bl) {
            this.attempts_remaining = n;
            if (bl) {
                BasicResourcePool.this.incrementPendingAcquires();
                if (logger.isLoggable(MLevel.FINEST)) {
                    logger.finest("Starting acquisition series. Incremented pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + n);
                }
            } else if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("Continuing acquisition series. pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                boolean bl = false;
                try {
                    boolean bl2;
                    boolean bl3;
                    BasicResourcePool.this.lockMain.lock();
                    try {
                        bl3 = BasicResourcePool.this.force_kill_acquires;
                        bl2 = BasicResourcePool.this.broken;
                    }
                    finally {
                        BasicResourcePool.this.lockMain.unlock();
                    }
                    if (!bl2 && !bl3) {
                        BasicResourcePool.this.doAcquireAndDecrementPendingAcquiresWithinLockOnSuccess();
                    } else {
                        BasicResourcePool.this.decrementPendingAcquires();
                        bl = true;
                    }
                    try {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest("Acquisition series terminated " + (bl2 ? "because this resource pool has been close()ed" : (bl3 ? "because force-kill-acquires is pending" : "successfully")) + ". Decremented pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + this.attempts_remaining);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Exception during logging:");
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    MLevel mLevel;
                    BasicResourcePool.this.setLastAcquisitionFailure(exception);
                    if (this.attempts_remaining == 0) {
                        BasicResourcePool.this.decrementPendingAcquires();
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, this + " -- Acquisition Attempt Failed!!! Clearing pending acquires. While trying to acquire a needed new resource, we failed to succeed more than the maximum number of allowed acquisition attempts (" + BasicResourcePool.this.num_acq_attempts + "). Last acquisition attempt exception: ", (Throwable)exception);
                        }
                        if (BasicResourcePool.this.break_on_acquisition_failure) {
                            if (logger.isLoggable(MLevel.SEVERE)) {
                                logger.severe("A RESOURCE POOL IS PERMANENTLY BROKEN! [" + this + "] (because a series of " + BasicResourcePool.this.num_acq_attempts + " acquisition attempts failed.)");
                            }
                            BasicResourcePool.this.unexpectedBreak();
                        } else {
                            try {
                                BasicResourcePool.this.forceKillAcquires();
                            }
                            catch (InterruptedException interruptedException) {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "Failed to force-kill pending acquisition attempts after acquisition failue,  due to an InterruptedException!", (Throwable)interruptedException);
                                }
                                bl = true;
                            }
                        }
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest("Acquisition series terminated unsuccessfully. Decremented pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + this.attempts_remaining);
                        }
                        break block25;
                    }
                    MLevel mLevel2 = mLevel = this.attempts_remaining > 0 ? MLevel.FINE : MLevel.INFO;
                    if (logger.isLoggable(mLevel)) {
                        logger.log(mLevel, "An exception occurred while acquiring a poolable resource. Will retry.", (Throwable)exception);
                    }
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            BasicResourcePool.this.taskRunner.postRunnable((Runnable)new ScatteredAcquireTask(ScatteredAcquireTask.this.attempts_remaining - 1, false));
                        }
                    };
                    BasicResourcePool.this.cullAndIdleRefurbishTimer.schedule(timerTask, BasicResourcePool.this.acq_attempt_delay);
                }
                finally {
                    if (bl) {
                        BasicResourcePool.this.recheckResizePool();
                    }
                }
            }
        }
    }
}

