/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v2.cfg.MLogConfigSource;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class MLogConfig {
    private static final MultiPropertiesConfig CONFIG;
    private static final List BOOTSTRAP_LOG_ITEMS;
    private static Method delayedDumpToLogger;

    static synchronized void ensureDelayedDumpToLogger() {
        try {
            if (delayedDumpToLogger == null) {
                Class<?> clazz = Class.forName("com.mchange.v2.cfg.MConfig");
                Class<?> clazz2 = Class.forName("com.mchange.v2.cfg.DelayedLogItem");
                delayedDumpToLogger = clazz.getMethod("dumpToLogger", clazz2, MLogger.class);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public static String getProperty(String string) {
        return CONFIG.getProperty(string);
    }

    public static void logDelayedItems(MLogger mLogger) {
        MLogConfig.ensureDelayedDumpToLogger();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(BOOTSTRAP_LOG_ITEMS);
        arrayList.addAll(CONFIG.getDelayedLogItems());
        HashSet hashSet = new HashSet();
        hashSet.addAll(arrayList);
        for (Object e : arrayList) {
            if (!hashSet.contains(e)) continue;
            hashSet.remove(e);
            try {
                delayedDumpToLogger.invoke(null, e, mLogger);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error(exception);
            }
        }
    }

    public static String dump() {
        return CONFIG.toString();
    }

    private MLogConfig() {
    }

    static {
        delayedDumpToLogger = null;
        String[] stringArray = new String[]{"/com/mchange/v2/log/default-mchange-log.properties"};
        String[] stringArray2 = new String[]{"/mchange-log.properties", "/"};
        ArrayList arrayList = new ArrayList();
        CONFIG = MLogConfigSource.readVmConfig(stringArray, stringArray2, arrayList);
        BOOTSTRAP_LOG_ITEMS = Collections.unmodifiableList(arrayList);
    }
}

