/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.dialog;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import java.util.Arrays;

@TargetApi(value=14)
public class AlertDialogFragment
extends DialogFragment {
    public static final String TAG = AlertDialogFragment.class.getSimpleName();
    public static final boolean DEBUG = false;
    private Params mParams;

    public static AlertDialogFragment create(Context context, CharSequence title, CharSequence message) {
        Builder builder = new Builder(context);
        builder.setTitle(title).setMessage(message);
        return builder.create();
    }

    void setParams(Params params) {
        this.mParams = params;
    }

    public void setTitle(CharSequence title) {
        this.mParams.mTitle = title;
    }

    public void setMessage(CharSequence message) {
        this.mParams.mMessage = message;
    }

    public void setIcon(int iconId) {
        this.mParams.mIconId = iconId;
    }

    public void setIcon(Drawable icon) {
        this.mParams.mIcon = icon;
    }

    public void setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mParams.mPositiveButtonText = text;
        this.mParams.mPositiveButtonListener = listener;
    }

    public void setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mParams.mNegativeButtonText = text;
        this.mParams.mNegativeButtonListener = listener;
    }

    public void setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mParams.mNeutralButtonText = text;
        this.mParams.mNeutralButtonListener = listener;
    }

    public void setCancelable(boolean cancelable) {
        this.mParams.mCancelable = cancelable;
    }

    public void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mParams.mCanceledOnTouchOutside = canceledOnTouchOutside;
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mParams.mOnCancelListener = onCancelListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mParams.mOnDismissListener = onDismissListener;
    }

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.mParams.mOnKeyListener = onKeyListener;
    }

    public void setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
        this.mParams.mItems = items;
        this.mParams.mOnClickListener = listener;
    }

    public void setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
        this.mParams.mAdapter = adapter;
        this.mParams.mOnClickListener = listener;
    }

    public void setView(View view) {
        this.mParams.mView = view;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public Dialog onCreateDialog(Bundle bundle) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        if (this.mParams.mIconId > 0) {
            builder.setIcon(this.mParams.mIconId);
        } else if (this.mParams.mIcon != null) {
            builder.setIcon(this.mParams.mIcon);
        }
        if (this.mParams.mTitle != null) {
            builder.setTitle(this.mParams.mTitle);
        }
        if (this.mParams.mMessage != null) {
            builder.setMessage(this.mParams.mMessage);
        }
        if (this.mParams.mPositiveButtonText != null) {
            builder.setPositiveButton(this.mParams.mPositiveButtonText, this.mParams.mPositiveButtonListener);
        }
        if (this.mParams.mNegativeButtonText != null) {
            builder.setNegativeButton(this.mParams.mNegativeButtonText, this.mParams.mNegativeButtonListener);
        }
        if (this.mParams.mNeutralButtonText != null) {
            builder.setNeutralButton(this.mParams.mNeutralButtonText, this.mParams.mNeutralButtonListener);
        }
        if (this.mParams.mCustomTitleView != null) {
            builder.setCustomTitle(this.mParams.mCustomTitleView);
        }
        if (this.mParams.mView != null) {
            builder.setView(this.mParams.mView);
        }
        if (this.mParams.mIsSingleChoice) {
            if (this.mParams.mItems != null) {
                builder.setSingleChoiceItems(this.mParams.mItems, this.mParams.mCheckedItem, this.mParams.mOnClickListener);
            } else if (this.mParams.mAdapter != null) {
                builder.setSingleChoiceItems(this.mParams.mAdapter, this.mParams.mCheckedItem, this.mParams.mOnClickListener);
            }
        } else if (this.mParams.mIsMultiChoice) {
            if (this.mParams.mItems != null) {
                builder.setMultiChoiceItems(this.mParams.mItems, this.mParams.mCheckedItems, this.mParams.mOnCheckboxClickListener);
            }
        } else if (this.mParams.mItems != null) {
            builder.setItems(this.mParams.mItems, this.mParams.mOnClickListener);
        } else if (this.mParams.mAdapter != null) {
            builder.setAdapter(this.mParams.mAdapter, this.mParams.mOnClickListener);
        }
        builder.setCancelable(this.mParams.mCancelable);
        builder.setOnKeyListener(this.mParams.mOnKeyListener);
        AlertDialog dialog = builder.create();
        if (this.mParams.mWindowNoTitle) {
            dialog.requestWindowFeature(1);
        }
        dialog.setCanceledOnTouchOutside(this.mParams.mCanceledOnTouchOutside);
        return dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mParams.mOnDismissListener != null) {
            this.mParams.mOnDismissListener.onDismiss(dialog);
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.mParams.mOnCancelListener != null) {
            this.mParams.mOnCancelListener.onCancel(dialog);
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void dismiss() {
        super.dismiss();
    }

    public void dismissAllowingStateLoss() {
        super.dismissAllowingStateLoss();
    }

    public static class Builder {
        private Context mContext;
        private Params mParams = new Params();

        public Builder(Builder builder) {
            this.mContext = builder.mContext;
            this.mParams = builder.mParams;
        }

        public Builder(Context context) {
            this(context, 0);
        }

        public Builder(Context context, int theme) {
            this.mContext = context;
            this.mParams.mTheme = theme;
        }

        public Context getContext() {
            return this.mContext;
        }

        public Builder setTheme(int mTheme) {
            this.mParams.mTheme = mTheme;
            return this;
        }

        public int getTheme() {
            return this.mParams.mTheme;
        }

        public Builder setWindowNoTitle(boolean noTitle) {
            this.mParams.mWindowNoTitle = noTitle;
            return this;
        }

        public boolean isWindowNoTitle() {
            return this.mParams.mWindowNoTitle;
        }

        public Builder setTitle(int titleId) {
            this.mParams.mTitle = this.mContext.getText(titleId);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mParams.mTitle = title;
            return this;
        }

        public Builder setCustomTitle(View customTitleView) {
            this.mParams.mCustomTitleView = customTitleView;
            return this;
        }

        public Builder setMessage(int messageId) {
            this.mParams.mMessage = this.mContext.getText(messageId);
            return this;
        }

        public Builder setMessage(CharSequence message) {
            this.mParams.mMessage = message;
            return this;
        }

        public Builder setIcon(int iconId) {
            this.mParams.mIconId = iconId;
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.mParams.mIcon = icon;
            return this;
        }

        public Builder setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
            this.mParams.mPositiveButtonText = this.mContext.getText(textId);
            this.mParams.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mParams.mPositiveButtonText = text;
            this.mParams.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
            this.mParams.mNegativeButtonText = this.mContext.getText(textId);
            this.mParams.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mParams.mNegativeButtonText = text;
            this.mParams.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(int textId, DialogInterface.OnClickListener listener) {
            this.mParams.mNeutralButtonText = this.mContext.getText(textId);
            this.mParams.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mParams.mNeutralButtonText = text;
            this.mParams.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.mParams.mCancelable = cancelable;
            return this;
        }

        public Builder setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
            this.mParams.mCanceledOnTouchOutside = canceledOnTouchOutside;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.mParams.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
            this.mParams.mOnDismissListener = onDismissListener;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.mParams.mOnKeyListener = onKeyListener;
            return this;
        }

        public Builder setItems(int itemsId, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = this.mContext.getResources().getTextArray(itemsId);
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = items;
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
            this.mParams.mAdapter = adapter;
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setMultiChoiceItems(int itemsId, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.mParams.mItems = this.mContext.getResources().getTextArray(itemsId);
            this.mParams.mOnCheckboxClickListener = listener;
            this.mParams.mCheckedItems = checkedItems;
            this.mParams.mIsMultiChoice = true;
            return this;
        }

        public Builder setMultiChoiceItems(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.mParams.mItems = items;
            this.mParams.mOnCheckboxClickListener = listener;
            this.mParams.mCheckedItems = checkedItems;
            this.mParams.mIsMultiChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(int itemsId, int checkedItem, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = this.mContext.getResources().getTextArray(itemsId);
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = items;
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(ListAdapter adapter, int checkedItem, DialogInterface.OnClickListener listener) {
            this.mParams.mAdapter = adapter;
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
            this.mParams.mOnItemSelectedListener = listener;
            return this;
        }

        public Builder setView(View view) {
            this.mParams.mView = view;
            return this;
        }

        public AlertDialogFragment create() {
            AlertDialogFragment fragment = new AlertDialogFragment();
            fragment.setParams(this.mParams);
            return fragment;
        }
    }

    static class Params {
        public int mTheme;
        public boolean mWindowNoTitle;
        public int mIconId;
        public Drawable mIcon;
        public CharSequence mTitle;
        public View mCustomTitleView;
        public CharSequence mMessage;
        public CharSequence mPositiveButtonText;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public boolean mCancelable = true;
        public boolean mCanceledOnTouchOutside;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnDismissListener mOnDismissListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public CharSequence[] mItems;
        public ListAdapter mAdapter;
        public boolean[] mCheckedItems;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public int mCheckedItem = -1;
        public DialogInterface.OnClickListener mOnClickListener;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public View mView;

        Params() {
        }

        public String toString() {
            return "Params{mTheme=" + this.mTheme + ", mWindowNoTitle=" + this.mWindowNoTitle + ", mIconId=" + this.mIconId + ", mIcon=" + this.mIcon + ", mTitle=" + this.mTitle + ", mCustomTitleView=" + this.mCustomTitleView + ", mMessage=" + this.mMessage + ", mPositiveButtonText=" + this.mPositiveButtonText + ", mPositiveButtonListener=" + this.mPositiveButtonListener + ", mNegativeButtonText=" + this.mNegativeButtonText + ", mNegativeButtonListener=" + this.mNegativeButtonListener + ", mNeutralButtonText=" + this.mNeutralButtonText + ", mNeutralButtonListener=" + this.mNeutralButtonListener + ", mCancelable=" + this.mCancelable + ", mCanceledOnTouchOutside=" + this.mCanceledOnTouchOutside + ", mOnCancelListener=" + this.mOnCancelListener + ", mOnDismissListener=" + this.mOnDismissListener + ", mOnKeyListener=" + this.mOnKeyListener + ", mItems=" + Arrays.toString(this.mItems) + ", mAdapter=" + this.mAdapter + ", mOnClickListener=" + this.mOnClickListener + ", mView=" + this.mView + '}';
        }
    }
}

