/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.dialog;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;

@TargetApi(value=14)
public class ProgressDialogFragment
extends DialogFragment {
    private static final String TAG = ProgressDialogFragment.class.getSimpleName();
    private CharSequence mTitle;
    private CharSequence mMessage;
    private boolean mActivityReady = false;
    private Dialog mOldDialog;
    private boolean mCalledSuperDismiss = false;
    private boolean mAllowStateLoss;

    public static ProgressDialogFragment show(FragmentManager fragmentManager, CharSequence title, CharSequence message, boolean cancelable) {
        ProgressDialogFragment dialogFragment = new ProgressDialogFragment();
        dialogFragment.mTitle = title;
        dialogFragment.mMessage = message;
        dialogFragment.setCancelable(cancelable);
        dialogFragment.show(fragmentManager, TAG);
        return dialogFragment;
    }

    public static ProgressDialogFragment show(FragmentManager fragmentManager, CharSequence title, CharSequence message) {
        return ProgressDialogFragment.show(fragmentManager, title, message, false);
    }

    public static ProgressDialogFragment create(CharSequence title, CharSequence message, boolean cancelable) {
        ProgressDialogFragment dialogFragment = new ProgressDialogFragment();
        dialogFragment.mTitle = title;
        dialogFragment.mMessage = message;
        dialogFragment.setCancelable(cancelable);
        return dialogFragment;
    }

    public static ProgressDialogFragment create(CharSequence title, CharSequence message) {
        return ProgressDialogFragment.create(title, message, false);
    }

    public void show(FragmentManager manager) {
        this.show(manager, TAG);
    }

    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
    }

    public int show(FragmentTransaction transaction, String tag) {
        return super.show(transaction, tag);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.setStyle(2, 0);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity());
        dialog.setIndeterminate(true);
        dialog.setIndeterminateDrawable(null);
        dialog.setTitle(this.mTitle);
        dialog.setMessage(this.mMessage);
        return dialog;
    }

    public void onStart() {
        super.onStart();
        this.mActivityReady = true;
        if (this.mCalledSuperDismiss) {
            this.superDismiss();
        }
    }

    public void onStop() {
        super.onStop();
        this.mActivityReady = false;
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.mOldDialog != null && this.mOldDialog == dialog) {
            return;
        }
        super.onDismiss(dialog);
    }

    public void onDestroyView() {
        this.mOldDialog = this.getDialog();
        super.onDestroyView();
    }

    public void dismiss() {
        this.mAllowStateLoss = false;
        this.superDismiss();
    }

    public void dismissAllowingStateLoss() {
        this.mAllowStateLoss = true;
        this.superDismiss();
    }

    private void superDismiss() {
        this.mCalledSuperDismiss = true;
        if (this.mActivityReady) {
            if (this.mAllowStateLoss) {
                super.dismissAllowingStateLoss();
            } else {
                super.dismiss();
            }
        }
    }
}

