/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.endless;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import com.mcxiaoke.next.ui.internal.AdapterWrapper;

class EndlessAdapter
extends AdapterWrapper {
    private Context mContext;
    private FooterState mState = FooterState.NONE;
    private View mFooter = null;
    private OnFooterStateChangeListener mFooterStateChangeListener;

    public EndlessAdapter(Context context, ListAdapter wrapped) {
        super(wrapped);
        this.mContext = context;
    }

    public void setFooterStateChangeListener(OnFooterStateChangeListener listener) {
        this.mFooterStateChangeListener = listener;
    }

    public void setFooterView(View footerView) {
        this.mFooter = footerView;
    }

    public FooterState getState() {
        return this.mState;
    }

    public boolean isRefreshing() {
        return FooterState.PROGRESS.equals((Object)this.mState);
    }

    public boolean isIdle() {
        return FooterState.IDLE.equals((Object)this.mState);
    }

    public boolean isFooterShowing() {
        return true;
    }

    @Override
    public int getCount() {
        if (this.isFooterShowing()) {
            return super.getCount() + 1;
        }
        return super.getCount();
    }

    @Override
    public int getItemViewType(int position) {
        if (position == this.getWrappedAdapter().getCount()) {
            return -1;
        }
        return super.getItemViewType(position);
    }

    @Override
    public int getViewTypeCount() {
        return super.getViewTypeCount() + 1;
    }

    @Override
    public Object getItem(int position) {
        if (position >= super.getCount()) {
            return null;
        }
        return super.getItem(position);
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled(int position) {
        if (position >= super.getCount()) {
            return false;
        }
        return super.isEnabled(position);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (position == super.getCount() && this.isFooterShowing()) {
            return this.mFooter;
        }
        return super.getView(position, convertView, parent);
    }

    public void setState(FooterState newState, boolean needNotify) {
        boolean stateChanged = !this.mState.equals((Object)newState);
        FooterState oldState = this.mState;
        this.mState = newState;
        if (stateChanged && needNotify && this.mFooterStateChangeListener != null) {
            this.mFooterStateChangeListener.onFooterStateChanged(this.mState, this);
        }
    }

    protected Context getContext() {
        return this.mContext;
    }

    public static interface OnFooterStateChangeListener {
        public void onFooterStateChanged(FooterState var1, EndlessAdapter var2);
    }

    public static enum FooterState {
        NONE,
        PROGRESS,
        IDLE;

    }
}

