/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.endless;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mcxiaoke.next.ui.endless.EndlessAdapter;
import com.mcxiaoke.next.ui.view.SimpleProgressView;

public class EndlessListView
extends ListView
implements AbsListView.OnScrollListener,
EndlessAdapter.OnFooterStateChangeListener {
    public static final String TAG = EndlessListView.class.getSimpleName();
    public static final boolean DEBUG = false;
    private SimpleProgressView mFooter;
    private EndlessAdapter mEndlessAdapter;
    private AbsListView.OnScrollListener mOnScrollListener;
    private OnFooterRefreshListener mOnRefreshListener;
    private int mFirstVisibleItem;
    private int mVisibleItemCount;
    private int mTotalItemCount;
    private boolean mLoading = false;
    private int mScrollState = 0;
    private RefreshMode mRefreshMode = RefreshMode.AUTO;

    public EndlessListView(Context context) {
        super(context);
        this.initialize(context);
    }

    public EndlessListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public EndlessListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.mFooter = new SimpleProgressView(context);
        this.setFadingEdgeLength(0);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public void setAdapter(ListAdapter adapter) {
        this.mEndlessAdapter = new EndlessAdapter(this.getContext(), adapter);
        this.mEndlessAdapter.setFooterView((View)this.mFooter);
        this.mEndlessAdapter.setFooterStateChangeListener(this);
        super.setAdapter((ListAdapter)this.mEndlessAdapter);
    }

    public void setOnFooterRefreshListener(OnFooterRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public void setRefreshMode(RefreshMode refreshMode) {
        this.mRefreshMode = refreshMode;
        this.checkFooterClick();
    }

    public boolean isAutoRefresh() {
        return RefreshMode.AUTO.equals((Object)this.mRefreshMode);
    }

    public boolean isClickRefresh() {
        return RefreshMode.CLICK.equals((Object)this.mRefreshMode);
    }

    public RefreshMode getRefreshMode() {
        return this.mRefreshMode;
    }

    public void showFooterText(int resId) {
        this.showFooterText(this.getResources().getString(resId));
    }

    public void showFooterText(CharSequence text) {
        this.mEndlessAdapter.setState(EndlessAdapter.FooterState.IDLE, true);
        this.mFooter.showText(text);
    }

    public void showFooterRefreshing() {
        this.setRefreshing(false);
    }

    private void setRefreshing(boolean needNotify) {
        if (this.isRefreshing()) {
            return;
        }
        this.mEndlessAdapter.setState(EndlessAdapter.FooterState.PROGRESS, needNotify);
        this.mFooter.showProgress();
    }

    public void showFooterEmpty() {
        this.mEndlessAdapter.setState(EndlessAdapter.FooterState.NONE, true);
        this.mFooter.showEmpty();
    }

    private boolean isRefreshing() {
        return this.mEndlessAdapter.isRefreshing();
    }

    private void checkFooterClick() {
        if (this.mFooter != null) {
            if (this.isClickRefresh()) {
                this.mFooter.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        EndlessListView.this.setRefreshing(true);
                    }
                });
            } else {
                this.mFooter.setOnClickListener(null);
            }
        }
    }

    private void onRefresh() {
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onFooterRefresh(this);
        }
    }

    private void onIdle() {
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onFooterIdle(this);
        }
    }

    private void onNone() {
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onFooterIdle(this);
        }
    }

    @Override
    public void onFooterStateChanged(EndlessAdapter.FooterState state, EndlessAdapter adapter) {
        if (EndlessAdapter.FooterState.PROGRESS.equals((Object)state)) {
            this.onRefresh();
        } else if (EndlessAdapter.FooterState.IDLE.equals((Object)state)) {
            this.mLoading = false;
            this.onIdle();
        } else {
            this.mLoading = false;
            this.onNone();
        }
    }

    private void checkRefresh() {
        if (!this.isAutoRefresh()) {
            return;
        }
        if (this.isRefreshing()) {
            return;
        }
        if (this.mTotalItemCount == 0 || this.mVisibleItemCount >= this.mTotalItemCount) {
            return;
        }
        if (this.mFirstVisibleItem + this.mVisibleItemCount >= this.mTotalItemCount) {
            this.mLoading = true;
            this.setRefreshing(true);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
        this.mScrollState = scrollState;
        if (0 == this.mScrollState) {
            this.checkRefresh();
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        this.mFirstVisibleItem = firstVisibleItem;
        this.mVisibleItemCount = visibleItemCount;
        this.mTotalItemCount = totalItemCount;
    }

    public static interface OnFooterRefreshListener {
        public void onFooterRefresh(EndlessListView var1);

        public void onFooterIdle(EndlessListView var1);
    }

    public static enum RefreshMode {
        AUTO,
        CLICK,
        NONE;

    }
}

