/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.list;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import com.mcxiaoke.next.ui.internal.AdapterWrapper;
import com.mcxiaoke.next.ui.list.ListViewExtend;
import com.mcxiaoke.next.ui.view.SimpleProgressView;

class AdapterExtend
extends AdapterWrapper {
    private static final String TAG = AdapterExtend.class.getSimpleName();
    private static final boolean DEBUG = false;
    private Context mContext;
    private boolean mEnableRefreshing;
    private boolean mRefreshing;
    private SimpleProgressView mFooter;
    private ListViewExtend.OnRefreshListener mRefreshListener;

    public AdapterExtend(Context context, ListAdapter wrapped) {
        super(wrapped);
        this.mContext = context;
        this.mEnableRefreshing = true;
        this.mRefreshing = false;
        this.mFooter = new SimpleProgressView(context);
    }

    public void setRefreshListener(ListViewExtend.OnRefreshListener listener) {
        this.mRefreshListener = listener;
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    public boolean isEnableRefreshing() {
        return this.mEnableRefreshing;
    }

    public void setEnableRefreshing(boolean value) {
        this.mEnableRefreshing = value;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mFooter.setOnClickListener(listener);
    }

    @Override
    public int getCount() {
        if (this.isEnableRefreshing()) {
            return super.getCount() + 1;
        }
        return super.getCount();
    }

    @Override
    public int getItemViewType(int position) {
        if (position == this.getWrappedAdapter().getCount() && this.isEnableRefreshing()) {
            return -1;
        }
        return super.getItemViewType(position);
    }

    @Override
    public int getViewTypeCount() {
        if (this.isEnableRefreshing()) {
            return super.getViewTypeCount() + 1;
        }
        return super.getViewTypeCount();
    }

    @Override
    public Object getItem(int position) {
        if (position >= super.getCount()) {
            return null;
        }
        return super.getItem(position);
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled(int position) {
        if (position >= super.getCount()) {
            return false;
        }
        return super.isEnabled(position);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (position == super.getCount() && this.isEnableRefreshing()) {
            return this.mFooter;
        }
        return super.getView(position, convertView, parent);
    }

    public void onStateChanged(boolean refreshing, boolean needNotify) {
        boolean stateChanged = refreshing != this.mRefreshing;
        this.mRefreshing = refreshing;
        if (stateChanged && needNotify && this.mRefreshListener != null) {
            this.mRefreshListener.onRefresh(null);
        }
    }

    protected Context getContext() {
        return this.mContext;
    }

    public void setRefreshing(boolean needNotify) {
        if (this.isRefreshing()) {
            return;
        }
        this.onStateChanged(true, needNotify);
        this.mFooter.showProgress();
    }

    public void showFooterEmpty() {
        this.onStateChanged(false, true);
        this.mFooter.showEmpty();
    }

    public void showFooterText(int resId) {
        this.showFooterText(this.getContext().getString(resId));
    }

    public void showFooterText(CharSequence text) {
        this.onStateChanged(false, true);
        this.mFooter.showText(text);
    }
}

