/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.list;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mcxiaoke.next.ui.list.AdapterExtend;

public class ListViewExtend
extends ListView
implements AbsListView.OnScrollListener {
    public static final String TAG = ListViewExtend.class.getSimpleName();
    public static final boolean DEBUG = false;
    public static final int MODE_NONE = 0;
    public static final int MODE_MANUAL = 1;
    public static final int MODE_AUTO = 2;
    private AdapterExtend mEndlessAdapter;
    private AbsListView.OnScrollListener mOnScrollListener;
    private OnRefreshListener mOnRefreshListener;
    private int mFirstVisibleItem;
    private int mVisibleItemCount;
    private int mTotalItemCount;
    private int mRefreshMode = 0;

    public ListViewExtend(Context context) {
        super(context);
        this.setUp(context);
    }

    public ListViewExtend(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setUp(context);
    }

    public ListViewExtend(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setUp(context);
    }

    private void setUp(Context context) {
        this.setFadingEdgeLength(0);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public void setAdapter(ListAdapter adapter) {
        this.mEndlessAdapter = new AdapterExtend(this.getContext(), adapter);
        this.mEndlessAdapter.setRefreshListener(new OnRefreshListener(){

            @Override
            public void onRefresh(ListViewExtend listView) {
                ListViewExtend.this.notifyRefresh();
            }
        });
        super.setAdapter((ListAdapter)this.mEndlessAdapter);
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public void setRefreshMode(int mode) {
        this.mRefreshMode = mode;
        this.checkManualRefresh();
    }

    public int getRefreshMode() {
        return this.mRefreshMode;
    }

    public void showFooterRefreshing() {
        this.mEndlessAdapter.setRefreshing(false);
    }

    public void showFooterEmpty() {
        this.mEndlessAdapter.showFooterEmpty();
    }

    public void showFooterText(int resId) {
        this.mEndlessAdapter.showFooterText(resId);
    }

    public void showFooterText(CharSequence text) {
        this.mEndlessAdapter.showFooterText(text);
    }

    public boolean isRefreshing() {
        return this.mEndlessAdapter.isRefreshing();
    }

    private void notifyRefresh() {
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh(this);
        }
    }

    private void checkManualRefresh() {
        if (this.mEndlessAdapter == null) {
            return;
        }
        if (this.mRefreshMode == 1) {
            this.mEndlessAdapter.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListViewExtend.this.mEndlessAdapter.setRefreshing(true);
                }
            });
        } else {
            this.mEndlessAdapter.setOnClickListener(null);
        }
    }

    private void checkAutoRefresh() {
        if (this.mRefreshMode != 2) {
            return;
        }
        if (this.isRefreshing()) {
            return;
        }
        if (this.mTotalItemCount == 0 || this.mVisibleItemCount >= this.mTotalItemCount) {
            return;
        }
        if (this.mFirstVisibleItem + this.mVisibleItemCount >= this.mTotalItemCount) {
            this.mEndlessAdapter.setRefreshing(true);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
        if (0 == scrollState) {
            this.checkAutoRefresh();
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        this.mFirstVisibleItem = firstVisibleItem;
        this.mVisibleItemCount = visibleItemCount;
        this.mTotalItemCount = totalItemCount;
    }

    public static interface OnRefreshListener {
        public void onRefresh(ListViewExtend var1);
    }
}

