/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.mcxiaoke.next.ui.R;
import java.lang.reflect.Field;

public class AspectRatioImageView
extends ImageView {
    private static final String TAG = AspectRatioImageView.class.getSimpleName();
    int mMaxWidth = Integer.MAX_VALUE;
    int mMaxHeight = Integer.MAX_VALUE;
    private int mStretch;
    private static final int STRETCH_UNDEFINED = -1;
    private static final int STRETCH_HORIZONTAL = 0;
    private static final int STRETCH_VERTICAL = 1;

    public AspectRatioImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AspectRatioImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AspectRatioImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        try {
            Field maxWidthField = ImageView.class.getDeclaredField("mMaxWidth");
            Field maxHeightField = ImageView.class.getDeclaredField("mMaxHeight");
            maxWidthField.setAccessible(true);
            maxHeightField.setAccessible(true);
            this.mMaxWidth = (Integer)maxWidthField.get((Object)this);
            this.mMaxHeight = (Integer)maxHeightField.get((Object)this);
        }
        catch (SecurityException maxWidthField) {
        }
        catch (NoSuchFieldException maxWidthField) {
        }
        catch (IllegalArgumentException maxWidthField) {
        }
        catch (IllegalAccessException maxWidthField) {
            // empty catch block
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AspectRatioImageView);
        this.mStretch = ta.getInt(R.styleable.AspectRatioImageView_ari_stretch, -1);
        ta.recycle();
        this.setAdjustViewBounds(true);
    }

    public void setMaxWidth(int maxWidth) {
        super.setMaxWidth(maxWidth);
        this.mMaxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        super.setMaxHeight(maxHeight);
        this.mMaxHeight = maxHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Drawable drawable = this.getDrawable();
        boolean setMeasuredDimension = false;
        if (drawable != null) {
            float dih;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (0x40000000 == View.MeasureSpec.getMode((int)heightMeasureSpec) && (height == 0 || 1 == this.mStretch)) {
                float diw = drawable.getIntrinsicWidth();
                if (diw > 0.0f) {
                    height = (int)Math.max((float)this.getSuggestedMinimumHeight(), Math.min((float)width * ((float)drawable.getIntrinsicHeight() / diw), (float)this.mMaxHeight));
                    this.setMeasuredDimension(width, height);
                    setMeasuredDimension = true;
                }
            } else if (0x40000000 == View.MeasureSpec.getMode((int)widthMeasureSpec) && (width == 0 || 0 == this.mStretch) && (dih = (float)drawable.getIntrinsicHeight()) > 0.0f) {
                width = (int)Math.max((float)this.getSuggestedMinimumWidth(), Math.min((float)height * ((float)drawable.getIntrinsicWidth() / dih), (float)this.mMaxWidth));
                this.setMeasuredDimension(width, height);
                setMeasuredDimension = true;
            }
        }
        if (!setMeasuredDimension) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

