/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.view;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ListView;

public class AutoScrollListView
extends ListView {
    private static final float PREFERRED_SELECTION_OFFSET_FROM_TOP = 0.33f;
    private int mRequestedScrollPosition = -1;
    private boolean mSmoothScrollRequested;

    public AutoScrollListView(Context context) {
        super(context);
    }

    public AutoScrollListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoScrollListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void requestPositionToScreen(int position, boolean smoothScroll) {
        this.mRequestedScrollPosition = position;
        this.mSmoothScrollRequested = smoothScroll;
        this.requestLayout();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.mRequestedScrollPosition == -1) {
            return;
        }
        int position = this.mRequestedScrollPosition;
        this.mRequestedScrollPosition = -1;
        int firstPosition = this.getFirstVisiblePosition() + 1;
        int lastPosition = this.getLastVisiblePosition();
        if (position >= firstPosition && position <= lastPosition) {
            return;
        }
        int offset = (int)((float)this.getHeight() * 0.33f);
        if (!this.mSmoothScrollRequested) {
            this.setSelectionFromTop(position, offset);
            super.layoutChildren();
        } else {
            int twoScreens = (lastPosition - firstPosition) * 2;
            if (position < firstPosition) {
                int preliminaryPosition = position + twoScreens;
                if (preliminaryPosition >= this.getCount()) {
                    preliminaryPosition = this.getCount() - 1;
                }
                if (preliminaryPosition < firstPosition) {
                    this.setSelection(preliminaryPosition);
                    super.layoutChildren();
                }
            } else {
                int preliminaryPosition = position - twoScreens;
                if (preliminaryPosition < 0) {
                    preliminaryPosition = 0;
                }
                if (preliminaryPosition > lastPosition) {
                    this.setSelection(preliminaryPosition);
                    super.layoutChildren();
                }
            }
            AutoScrollListView.smoothScrollToPositionCompat(this, position, offset);
        }
    }

    public static void smoothScrollToPositionCompat(ListView listView, int position, int offset) {
        if (Build.VERSION.SDK_INT >= 11) {
            listView.smoothScrollToPositionFromTop(position, offset);
        }
        int firstVisible = listView.getFirstVisiblePosition();
        int lastVisible = listView.getLastVisiblePosition();
        if (position < firstVisible) {
            listView.smoothScrollToPosition(position);
        } else {
            listView.smoothScrollToPosition(position + lastVisible - firstVisible - 2);
        }
    }
}

