/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.mcxiaoke.next.ui.R;

public class CircularImageView
extends ImageView {
    private int borderWidth;
    private int canvasSize;
    private Bitmap image;
    private Paint paint = new Paint();
    private Paint paintBorder;

    public CircularImageView(Context context) {
        this(context, null);
    }

    public CircularImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.paint.setAntiAlias(true);
        this.paintBorder = new Paint();
        this.paintBorder.setAntiAlias(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularImageView, defStyle, 0);
        if (a.getBoolean(R.styleable.CircularImageView_ci_border, true)) {
            this.setBorderWidth(a.getColor(R.styleable.CircularImageView_ci_border_width, 4));
            this.setBorderColor(a.getInt(R.styleable.CircularImageView_ci_border_color, -1));
        }
        if (a.getBoolean(R.styleable.CircularImageView_ci_shadow, false)) {
            this.addShadow();
        }
        a.recycle();
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.requestLayout();
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        if (this.paintBorder != null) {
            this.paintBorder.setColor(borderColor);
        }
        this.invalidate();
    }

    @TargetApi(value=11)
    public void addShadow() {
        this.setLayerType(1, this.paintBorder);
        this.paintBorder.setShadowLayer(4.0f, 0.0f, 2.0f, -16777216);
    }

    public void onDraw(Canvas canvas) {
        Drawable drawable = this.getDrawable();
        if (drawable instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable;
            this.image = bitmapDrawable.getBitmap();
        }
        if (this.image != null) {
            this.canvasSize = canvas.getWidth();
            if (canvas.getHeight() < this.canvasSize) {
                this.canvasSize = canvas.getHeight();
            }
            BitmapShader shader = new BitmapShader(Bitmap.createScaledBitmap((Bitmap)this.image, (int)this.canvasSize, (int)this.canvasSize, (boolean)false), Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.paint.setShader((Shader)shader);
            int circleCenter = (this.canvasSize - this.borderWidth * 2) / 2;
            canvas.drawCircle((float)(circleCenter + this.borderWidth), (float)(circleCenter + this.borderWidth), (float)((this.canvasSize - this.borderWidth * 2) / 2 + this.borderWidth) - 4.0f, this.paintBorder);
            canvas.drawCircle((float)(circleCenter + this.borderWidth), (float)(circleCenter + this.borderWidth), (float)((this.canvasSize - this.borderWidth * 2) / 2) - 4.0f, this.paint);
        } else {
            super.onDraw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureWidth(widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.canvasSize);
        return result;
    }

    private int measureHeight(int measureSpecHeight) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpecHeight);
        int specSize = View.MeasureSpec.getSize((int)measureSpecHeight);
        result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.canvasSize);
        return result + 2;
    }
}

