/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ScrollView;
import java.util.ArrayList;

public class NonLockingScrollView
extends ScrollView {
    private boolean mInCustomDrag = false;
    private final ArrayList<View> mChildrenNeedingAllTouches = new ArrayList();
    private static final Rect sHitFrame = new Rect();

    public NonLockingScrollView(Context context) {
        super(context);
    }

    public NonLockingScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public NonLockingScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean isUp;
        int action = ev.getActionMasked();
        boolean bl = isUp = action == 1;
        if (isUp && this.mInCustomDrag) {
            this.mInCustomDrag = false;
            this.onTouchEvent(ev);
            return true;
        }
        if (!this.mInCustomDrag && !NonLockingScrollView.isEventOverChild(ev, this.mChildrenNeedingAllTouches)) {
            return super.onInterceptTouchEvent(ev);
        }
        this.mInCustomDrag = super.onInterceptTouchEvent(ev);
        if (this.mInCustomDrag) {
            this.onTouchEvent(ev);
        }
        return false;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.excludeChildrenFromInterceptions((View)this);
    }

    private void excludeChildrenFromInterceptions(View node) {
        if (node instanceof WebView) {
            this.mChildrenNeedingAllTouches.add(node);
        } else if (node instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)node;
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                this.excludeChildrenFromInterceptions(child);
            }
        }
    }

    private static boolean isEventOverChild(MotionEvent ev, ArrayList<View> children) {
        int actionIndex = ev.getActionIndex();
        float x = ev.getX(actionIndex);
        float y = ev.getY(actionIndex);
        for (View child : children) {
            if (!NonLockingScrollView.canViewReceivePointerEvents(child)) continue;
            child.getHitRect(sHitFrame);
            if (!sHitFrame.contains((int)x, (int)y)) continue;
            return true;
        }
        return false;
    }

    private static boolean canViewReceivePointerEvents(View child) {
        return child.getVisibility() == 0 || child.getAnimation() != null;
    }
}

