/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.mcxiaoke.next.ui.R;

public class SimpleProgressView
extends LinearLayout {
    private TextView textView;
    private ViewGroup progressView;
    private ProgressBar progressBar;
    private TextView progressTextView;

    public SimpleProgressView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SimpleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    @TargetApi(value=11)
    public SimpleProgressView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        inflater.inflate(R.layout.cv_simple_progress, (ViewGroup)this);
        this.textView = (TextView)this.findViewById(R.id.spv_text);
        this.progressView = (ViewGroup)this.findViewById(R.id.spv_progress);
        this.progressBar = (ProgressBar)this.findViewById(R.id.spv_progress_bar);
        this.progressTextView = (TextView)this.findViewById(R.id.spv_progress_text);
    }

    public void showProgress() {
        this.showProgress(false);
    }

    public void showProgress(boolean withText) {
        this.show();
        this.textView.setVisibility(8);
        this.progressView.setVisibility(0);
        this.progressTextView.setVisibility(withText ? 0 : 8);
    }

    private void showText() {
        this.show();
        this.progressView.setVisibility(8);
        this.textView.setVisibility(0);
    }

    public void showText(int resId) {
        String text = this.getContext().getString(resId);
        this.showText(text);
    }

    public void showText(CharSequence text) {
        this.textView.setText(text);
        this.showText();
    }

    public void showEmpty() {
        this.showText("");
    }

    public void setTextSize(float size) {
        this.textView.setTextSize(size);
    }

    public void setTextSize(int unit, float size) {
        this.textView.setTextSize(unit, size);
    }

    public void setTextColor(int color) {
        this.textView.setTextColor(color);
    }

    public void setTextColor(ColorStateList color) {
        this.textView.setTextColor(color);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void show() {
        this.setVisibility(0);
    }
}

