/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.widget;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.Toast;
import com.mcxiaoke.next.ui.R;
import com.mcxiaoke.next.ui.widget.ShareTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@TargetApi(value=14)
public class AdvancedShareActionProvider
extends ActionProvider
implements MenuItem.OnMenuItemClickListener {
    public static final boolean DEBUG = false;
    public static final String TAG = AdvancedShareActionProvider.class.getSimpleName();
    public static final int WEIGHT_MAX = Integer.MAX_VALUE;
    public static final int WEIGHT_DEFAULT = 0;
    public static final int DEFAULT_LIST_LENGTH = 4;
    private final Object mLock = new Object();
    private int mDefaultLength;
    private CharSequence mExpandLabel;
    private volatile int mWeightCounter;
    private Context mContext;
    private PackageManager mPackageManager;
    private Intent mIntent;
    private MenuItem.OnMenuItemClickListener mOnMenuItemClickListener;
    private List<String> mExtraPackages = new ArrayList<String>();
    private List<String> mToRemovePackages = new ArrayList<String>();
    private List<ShareTarget> mExtraTargets = new ArrayList<ShareTarget>();
    private List<ShareTarget> mShareTargets = new ArrayList<ShareTarget>();

    public AdvancedShareActionProvider(Context context) {
        super(context);
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mWeightCounter = Integer.MAX_VALUE;
        this.mDefaultLength = 4;
        this.mExpandLabel = this.mContext.getString(R.string.share_action_provider_expand_label);
    }

    public void setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener listener) {
        this.mOnMenuItemClickListener = listener;
    }

    public void addCustomPackage(String pkg) {
        if (!this.mExtraPackages.contains(pkg)) {
            this.mExtraPackages.add(pkg);
        }
    }

    public void addCustomPackages(Collection<String> pkgs) {
        for (String pkg : pkgs) {
            this.addCustomPackage(pkg);
        }
    }

    public void clearCustomPackages() {
        this.mExtraPackages.clear();
    }

    public void removePackage(String pkg) {
        this.mToRemovePackages.add(pkg);
    }

    public void addShareTarget(ShareTarget target) {
        target.weight = --this.mWeightCounter;
        this.mExtraTargets.add(target);
    }

    public void setDefaultLength(int length) {
        this.mDefaultLength = length;
    }

    public int getDefaultLength() {
        return this.mDefaultLength;
    }

    public void setExpandLabel(CharSequence label) {
        this.mExpandLabel = label;
    }

    public void setShareIntent(Intent intent) {
        this.mIntent = intent;
        this.reloadActivities();
    }

    public void setIntentExtras(Bundle extras) {
        this.mIntent.replaceExtras(extras);
    }

    public void addIntentExtras(Bundle extras) {
        this.mIntent.putExtras(extras);
    }

    public void setIntentExtras(String subject, String text) {
        this.setIntentExtras(subject, text, null);
    }

    public void setIntentExtras(Uri imageUri) {
        this.setIntentExtras(null, null, imageUri);
    }

    public void setIntentExtras(String subject, String text, Uri imageUri) {
        this.mIntent.putExtra("android.intent.extra.SUBJECT", subject);
        this.mIntent.putExtra("android.intent.extra.TEXT", text);
        if (imageUri != null) {
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imageUri);
        }
    }

    public List<ShareTarget> getShareTargets() {
        return this.mShareTargets;
    }

    public List<ShareTarget> getDefaultShareTargets() {
        int length = Math.min(this.mDefaultLength, this.mShareTargets.size());
        return this.mShareTargets.subList(0, length);
    }

    private void reloadActivities() {
        this.loadShareTargets();
        this.sortShareTargets();
    }

    private void loadShareTargets() {
        if (this.mIntent != null) {
            this.mShareTargets.clear();
            List activities = this.mPackageManager.queryIntentActivities(this.mIntent, 65536);
            if (activities == null || activities.isEmpty()) {
                return;
            }
            for (ResolveInfo resolveInfo : activities) {
                ShareTarget target = this.toShareTarget(resolveInfo);
                this.mShareTargets.add(target);
            }
        }
    }

    private void sortShareTargets() {
        if (this.mShareTargets.size() > 0) {
            ShareTarget target;
            for (String pkg : this.mExtraPackages) {
                target = this.findShareTarget(pkg);
                if (target == null) continue;
                target.weight = --this.mWeightCounter;
            }
            for (String pkg : this.mToRemovePackages) {
                target = this.findShareTarget(pkg);
                if (target == null) continue;
                this.mShareTargets.remove(target);
            }
            this.mShareTargets.addAll(this.mExtraTargets);
            Collections.sort(this.mShareTargets);
            this.mExtraTargets.clear();
            this.mExtraPackages.clear();
            this.mToRemovePackages.clear();
            int size = this.mShareTargets.size();
            for (int i = 0; i < size; ++i) {
                this.mShareTargets.get((int)i).id = i;
            }
        }
    }

    private ShareTarget findShareTarget(String pkg) {
        for (ShareTarget target : this.mShareTargets) {
            if (!pkg.equals(target.packageName)) continue;
            return target;
        }
        return null;
    }

    private ShareTarget toShareTarget(ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            return null;
        }
        ActivityInfo info = resolveInfo.activityInfo;
        ShareTarget target = new ShareTarget(info.loadLabel(this.mPackageManager), info.loadIcon(this.mPackageManager), null);
        target.packageName = info.packageName;
        target.className = info.name;
        return target;
    }

    public View onCreateActionView() {
        return null;
    }

    public boolean hasSubMenu() {
        return true;
    }

    public void onPrepareSubMenu(SubMenu subMenu) {
        ShareTarget target;
        int i;
        subMenu.clear();
        int length = Math.min(this.mDefaultLength, this.mShareTargets.size());
        Resources res = this.mContext.getResources();
        for (i = 0; i < length; ++i) {
            target = this.mShareTargets.get(i);
            subMenu.add(0, i, i, target.title).setIcon(target.icon).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
        }
        if (this.mDefaultLength < this.mShareTargets.size()) {
            subMenu = subMenu.addSubMenu(0, this.mDefaultLength, this.mDefaultLength, this.mExpandLabel);
            for (i = 0; i < this.mShareTargets.size(); ++i) {
                target = this.mShareTargets.get(i);
                subMenu.add(0, i, i, target.title).setIcon(target.icon).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
            }
        }
    }

    public boolean onMenuItemClick(MenuItem item) {
        boolean handled = false;
        ShareTarget target = this.mShareTargets.get(item.getItemId());
        if (target.listener != null) {
            handled = target.listener.onMenuItemClick(item);
        }
        if (handled) {
            return true;
        }
        if (this.mOnMenuItemClickListener != null) {
            handled = this.mOnMenuItemClickListener.onMenuItemClick(item);
        }
        if (handled) {
            return true;
        }
        if (target.packageName == null || target.className == null) {
            return true;
        }
        ComponentName chosenName = new ComponentName(target.packageName, target.className);
        Intent intent = new Intent(this.mIntent);
        intent.addFlags(0x10000000);
        intent.setComponent(chosenName);
        try {
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("onMenuItemClick() error: " + e));
            Toast.makeText((Context)this.mContext, (int)R.string.share_action_provider_target_not_found, (int)0).show();
        }
        return true;
    }
}

