/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.next.ui.widget;

import android.content.Context;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class ArrayAdapterCompat<T>
extends BaseAdapter
implements Filterable {
    protected final Object mLock = new Object();
    private boolean mNotifyOnChange = true;
    private Context mContext;
    protected List<T> mObjects;
    protected List<T> mOriginalValues;
    protected Filter mFilter;

    public ArrayAdapterCompat(Context context) {
        this.init(context, new ArrayList());
    }

    public ArrayAdapterCompat(Context context, T[] objects) {
        this.init(context, Arrays.asList(objects));
    }

    public ArrayAdapterCompat(Context context, List<T> objects) {
        this.init(context, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(object);
            } else {
                this.mObjects.add(object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(index, object);
            } else {
                this.mObjects.add(index, object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index, T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.set(index, object);
            } else {
                this.mObjects.set(index, object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public void setAll(Collection<? extends T> collection) {
        this.clear();
        this.addAll(collection);
    }

    public void setAll(T ... items) {
        this.clear();
        this.addAll(items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<? extends T> collection) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.addAll(collection);
            } else {
                this.mObjects.addAll(collection);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(T ... items) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                Collections.addAll(this.mOriginalValues, items);
            } else {
                Collections.addAll(this.mObjects, items);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(int index, Collection<? extends T> collection) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.addAll(index, collection);
            } else {
                this.mObjects.addAll(index, collection);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(int index, T ... items) {
        List<T> collection = Arrays.asList(items);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.addAll(index, collection);
            } else {
                this.mObjects.addAll(index, collection);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public List<T> getAllItems() {
        if (this.mOriginalValues != null) {
            return this.mOriginalValues;
        }
        return this.mObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(T object, int index) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(index, object);
            } else {
                this.mObjects.add(index, object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                return this.mOriginalValues.contains(object);
            }
            return this.mObjects.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                return this.mOriginalValues.indexOf(object);
            }
            return this.mObjects.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.remove(object);
            } else {
                this.mObjects.remove(object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAt(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.remove(index);
            } else {
                this.mObjects.remove(index);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> collection) {
        boolean result = false;
        Object object = this.mLock;
        synchronized (object) {
            Iterator<T> it = this.mOriginalValues != null ? this.mOriginalValues.iterator() : this.mObjects.iterator();
            while (it.hasNext()) {
                if (!collection.contains(it.next())) continue;
                it.remove();
                result = true;
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.clear();
            } else {
                this.mObjects.clear();
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<? super T> comparator) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                Collections.sort(this.mOriginalValues, comparator);
            } else {
                Collections.sort(this.mObjects, comparator);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNotifyOnChange = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.mNotifyOnChange = notifyOnChange;
    }

    private void init(Context context, List<T> objects) {
        this.mContext = context;
        this.mObjects = objects;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        return this.mObjects.size();
    }

    public T getItem(int position) {
        return this.mObjects.get(position);
    }

    public int getPosition(T item) {
        return this.mObjects.indexOf(item);
    }

    public long getItemId(int position) {
        return position;
    }

    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    public void setFilter(Filter filter) {
        this.mFilter = filter;
    }

    static String toLowerCase(String text) {
        return text == null ? null : text.toLowerCase(Locale.US);
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (ArrayAdapterCompat.this.mOriginalValues == null) {
                Object object = ArrayAdapterCompat.this.mLock;
                synchronized (object) {
                    ArrayAdapterCompat.this.mOriginalValues = new ArrayList(ArrayAdapterCompat.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                ArrayList list;
                Object object = ArrayAdapterCompat.this.mLock;
                synchronized (object) {
                    list = new ArrayList(ArrayAdapterCompat.this.mOriginalValues);
                }
                results.values = list;
                results.count = list.size();
            } else {
                ArrayList values;
                String prefixString = ArrayAdapterCompat.toLowerCase(prefix.toString());
                Object object = ArrayAdapterCompat.this.mLock;
                synchronized (object) {
                    values = new ArrayList(ArrayAdapterCompat.this.mOriginalValues);
                }
                ArrayList newValues = new ArrayList();
                block9: for (Object value : values) {
                    String valueText = ArrayAdapterCompat.toLowerCase(value.toString());
                    if (valueText.startsWith(prefixString)) {
                        newValues.add(value);
                        continue;
                    }
                    String[] words = valueText.split(" ");
                    int wordCount = words.length;
                    for (String word : words) {
                        if (!word.startsWith(prefixString)) continue;
                        newValues.add(value);
                        continue block9;
                    }
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayAdapterCompat.this.mObjects = (List)results.values;
            if (results.count > 0) {
                ArrayAdapterCompat.this.notifyDataSetChanged();
            } else {
                ArrayAdapterCompat.this.notifyDataSetInvalidated();
            }
        }
    }
}

