/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http;

import akka.http.javadsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.Rejection;
import akka.http.scaladsl.server.StandardRoute$;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.FutureDirectives$;
import akka.http.scaladsl.server.directives.HeaderMagnet;
import akka.http.scaladsl.server.directives.HeaderMagnet$;
import akka.http.scaladsl.server.directives.RouteDirectives$;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.TupleOps;
import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.akka.http.AuthHeaderDetail;
import com.mdsol.mauth.akka.http.MauthHeaderValues;
import com.mdsol.mauth.akka.http.MdsolAuthFailedRejection$;
import com.mdsol.mauth.akka.http.MdsolAuthMalformedHeaderRejection;
import com.mdsol.mauth.akka.http.MdsolAuthMissingHeaderRejection;
import com.mdsol.mauth.http.HttpVerbOps$;
import com.mdsol.mauth.http.X;
import com.mdsol.mauth.http.X$minusMWS$minusAuthentication$;
import com.mdsol.mauth.http.X$minusMWS$minusTime$;
import com.mdsol.mauth.scaladsl.Authenticator;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-ea\u0002\b\u0010!\u0003\r\tA\u0007\u0005\u0006S\u0001!\tA\u000b\u0005\u0006]\u0001!\ta\f\u0005\bE\u0002\u0011\r\u0011\"\u0001d\u0011\u00159\b\u0001\"\u0001y\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u00020!9\u00111\b\u0001\u0005\n\u0005u\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\tI\u0007\u0001C\u0001\u0003W:q!a \u0010\u0011\u0003\t\tI\u0002\u0004\u000f\u001f!\u0005\u00111\u0011\u0005\b\u0003\u000fcA\u0011AAE\u0005=i\u0015)\u001e;i\t&\u0014Xm\u0019;jm\u0016\u001c(B\u0001\t\u0012\u0003\u0011AG\u000f\u001e9\u000b\u0005I\u0019\u0012\u0001B1lW\u0006T!\u0001F\u000b\u0002\u000b5\fW\u000f\u001e5\u000b\u0005Y9\u0012!B7eg>d'\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nAb]2bY\u0006dwnZ4j]\u001eT!AJ\f\u0002\u0011QL\b/Z:bM\u0016L!\u0001K\u0012\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\t1\u0006\u0005\u0002\u001dY%\u0011Q&\b\u0002\u0005+:LG/\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u00031\u0011Vk\u0006CA\u0019F\u001d\t\u0011$I\u0004\u00024\u007f9\u0011A\u0007\u0010\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012B\u0001\t<\u0015\u0005\u0011\u0012BA\u001f?\u0003!\u00198-\u00197bINd'B\u0001\t<\u0013\t\u0001\u0015)\u0001\u0004tKJ4XM\u001d\u0006\u0003{yJ!a\u0011#\u0002\u000fA\f7m[1hK*\u0011\u0001)Q\u0005\u0003\r\u001e\u0013!\u0002R5sK\u000e$\u0018N^31\u0015\t\u0019E\tC\u0003J\u0005\u0001\u000f!*A\u0007bkRDWM\u001c;jG\u0006$xN\u001d\t\u0004\u00176{U\"\u0001'\u000b\u0005u\u001a\u0012B\u0001(M\u00055\tU\u000f\u001e5f]RL7-\u0019;peB\u0011\u0001kU\u0007\u0002#*\u0011!+H\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001+R\u0005\u00191U\u000f^;sK\")aK\u0001a\u0002/\u00069A/[7f_V$\bC\u0001-\\\u001b\u0005I&B\u0001.R\u0003!!WO]1uS>t\u0017B\u0001/Z\u000591\u0015N\\5uK\u0012+(/\u0019;j_:DQA\u0018\u0002A\u0004}\u000b\u0001D]3rk\u0016\u001cHOV1mS\u0012\fG/[8o)&lWm\\;u!\tA\u0006-\u0003\u0002b3\nAA)\u001e:bi&|g.\u0001\u0010fqR\u0014\u0018m\u0019;NoN\fU\u000f\u001e5f]RL7-\u0019;j_:DU-\u00193feV\tA\rE\u00022K\u001eL!AZ$\u0003\u0015\u0011K'/Z2uSZ,\u0017\u0007\u0005\u0002iY:\u0011\u0011N\u001b\t\u0003muI!a[\u000f\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003WvACa\u00019tkB\u0011A$]\u0005\u0003ev\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005!\u0018!\u000b+iSN\u0004S.\u001a;i_\u0012\u0004\u0013n\u001d\u0011g_J\u0004S*Y;uQ\u00022\u0016\u0007\t9s_R|7m\u001c7!_:d\u00170I\u0001w\u0003\u0015\u0019d\u0006\r\u00181\u0003YAW-\u00193feZ\u000bG.^3CsRK\b/Z'eg>dWCA=~)\rQ\u0018Q\u0002\t\u0004c\u0015\\\bC\u0001?~\u0019\u0001!QA \u0003C\u0002}\u0014\u0011\u0001V\t\u0005\u0003\u0003\t9\u0001E\u0002\u001d\u0003\u0007I1!!\u0002\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001HA\u0005\u0013\r\tY!\b\u0002\u0004\u0003:L\bbBA\b\t\u0001\u0007\u0011\u0011C\u0001\u0007[\u0006<g.\u001a;\u0011\u000b\u0005M\u0011\u0011D>\u000e\u0005\u0005U!bAA\f\t\u0006QA-\u001b:fGRLg/Z:\n\t\u0005m\u0011Q\u0003\u0002\r\u0011\u0016\fG-\u001a:NC\u001etW\r^\u0001\u0013Kb$(/Y2u\u001b\u0006+H\u000f\u001b%fC\u0012,'/\u0006\u0002\u0002\"A!\u0011'ZA\u0012!\u0011\t)#a\n\u000e\u0003=I1!!\u000b\u0010\u0005A\tU\u000f\u001e5IK\u0006$WM\u001d#fi\u0006LG\u000e\u000b\u0003\u0006aN,\u0018\u0001F3yiJ\f7\r^'xgRKW.\u001a%fC\u0012,'/\u0006\u0002\u00022A!\u0011'ZA\u001a!\ra\u0012QG\u0005\u0004\u0003oi\"\u0001\u0002'p]\u001eDCA\u00029tk\u00069R\r\u001f;sC\u000e$\u0018)\u001e;i\u0011\u0016\fG-\u001a:EKR\f\u0017\u000e\u001c\u000b\u0005\u0003\u007f\t)\u0005E\u0003\u001d\u0003\u0003\n\u0019#C\u0002\u0002Du\u0011aa\u00149uS>t\u0007BBA$\u000f\u0001\u0007q-A\u0002tiJ\fabZ3u#V,'/_*ue&tw\rF\u0002h\u0003\u001bBq!a\u0014\t\u0001\u0004\t\t&A\u0002sKF\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/\n\u0015!B7pI\u0016d\u0017\u0002BA.\u0003+\u00121\u0002\u0013;uaJ+\u0017/^3ti\u0006!R\r\u001f;sC\u000e$(+Z9vKN$\b*Z1eKJ$RaZA1\u0003KBq!a\u0019\n\u0001\u0004\t\t&A\u0004sKF,Xm\u001d;\t\r\u0005\u001d\u0014\u00021\u0001h\u0003)AW-\u00193fe:\u000bW.Z\u0001#Kb$(/Y2u\u0019\u0006$Xm\u001d;BkRDWM\u001c;jG\u0006$\u0018n\u001c8IK\u0006$WM]:\u0015\t\u00055\u0014Q\u000f\t\u0005c\u0015\fy\u0007\u0005\u0003\u0002&\u0005E\u0014bAA:\u001f\t\tR*Y;uQ\"+\u0017\rZ3s-\u0006dW/Z:\t\u000f\u0005]$\u00021\u0001\u0002z\u0005\u0011bOM(oYf\fU\u000f\u001e5f]RL7-\u0019;f!\ra\u00121P\u0005\u0004\u0003{j\"a\u0002\"p_2,\u0017M\\\u0001\u0010\u001b\u0006+H\u000f\u001b#je\u0016\u001cG/\u001b<fgB\u0019\u0011Q\u0005\u0007\u0014\t1Y\u0012Q\u0011\t\u0004\u0003K\u0001\u0011A\u0002\u001fj]&$h\b\u0006\u0002\u0002\u0002\u0002")
public interface MAuthDirectives
extends StrictLogging {
    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsAuthenticationHeader_$eq(Directive<Tuple1<String>> var1);

    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMAuthHeader_$eq(Directive<Tuple1<AuthHeaderDetail>> var1);

    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsTimeHeader_$eq(Directive<Tuple1<Object>> var1);

    public static /* synthetic */ Directive authenticate$(MAuthDirectives $this, Authenticator authenticator, FiniteDuration timeout, Duration requestValidationTimeout) {
        return $this.authenticate((Authenticator<Future>)authenticator, timeout, requestValidationTimeout);
    }

    default public Directive<BoxedUnit> authenticate(Authenticator<Future> authenticator, FiniteDuration timeout, Duration requestValidationTimeout) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(this.extractLatestAuthenticationHeaders(authenticator.isV2OnlyAuthenticate())), (Function1 & Serializable & scala.Serializable)mauthHeaderValues -> (Directive)BasicDirectives$.MODULE$.toStrictEntity(timeout).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest()), (Function1 & Serializable & scala.Serializable)req -> {
            Directive directive;
            RequestEntity requestEntity = req.entity();
            if (requestEntity instanceof HttpEntity.Strict) {
                HttpEntity.Strict strict = (HttpEntity.Strict)requestEntity;
                MAuthRequest mAuthRequest = new MAuthRequest(mauthHeaderValues.authenticator(), (byte[])strict.data().toArray(ClassTag$.MODULE$.Byte()), HttpVerbOps$.MODULE$.httpVerb(req.method()), Long.toString(mauthHeaderValues.time()), req.uri().path().toString(), this.getQueryString((HttpRequest)req));
                if (!authenticator.isV2OnlyAuthenticate()) {
                    String xmwsAuthenticationHeader = this.extractRequestHeader((HttpRequest)req, "x-mws-authentication");
                    String xmwsTimeHeader = this.extractRequestHeader((HttpRequest)req, "x-mws-time");
                    if (new StringOps(Predef$.MODULE$.augmentString(xmwsAuthenticationHeader)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(xmwsTimeHeader)).nonEmpty()) {
                        mAuthRequest.setXmwsSignature(xmwsAuthenticationHeader);
                        mAuthRequest.setXmwsTime(xmwsTimeHeader);
                    }
                }
                directive = Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(FutureDirectives$.MODULE$.onComplete((Function0 & Serializable & scala.Serializable)() -> (Future)authenticator.authenticate(mAuthRequest, requestValidationTimeout))), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Success success;
                    boolean bl;
                    Try try_ = x0$1;
                    if (try_ instanceof Success && (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
                        return BasicDirectives$.MODULE$.pass();
                    }
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{MdsolAuthFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
                }, Tuple$.MODULE$.forUnit());
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("MAUTH: Non-Strict Entity in Request");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                directive = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{MdsolAuthFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
            }
            Directive isAuthed = directive;
            return isAuthed;
        }, Tuple$.MODULE$.forUnit()), TupleOps.Join$.MODULE$.join0P())), Tuple$.MODULE$.forUnit());
    }

    public Directive<Tuple1<String>> extractMwsAuthenticationHeader();

    public static /* synthetic */ Directive headerValueByTypeMdsol$(MAuthDirectives $this, HeaderMagnet magnet) {
        return $this.headerValueByTypeMdsol(magnet);
    }

    default public <T> Directive<Tuple1<T>> headerValueByTypeMdsol(HeaderMagnet<T> magnet) {
        return Directives$.MODULE$.headerValuePF(magnet.extractPF()).$bar(StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection(magnet.headerName())})), Tuple$.MODULE$.forTuple1()));
    }

    public Directive<Tuple1<AuthHeaderDetail>> extractMAuthHeader();

    public Directive<Tuple1<Object>> extractMwsTimeHeader();

    private Option<AuthHeaderDetail> extractAuthHeaderDetail(String str) {
        BoxedUnit boxedUnit;
        if (str.startsWith("MWS ")) {
            BoxedUnit boxedUnit2;
            List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.replaceFirst("MWS ", "").split(":"))).toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                Some some2;
                String uuid = (String)((LinearSeqOptimized)some.get()).apply(0);
                String hash = (String)((LinearSeqOptimized)some.get()).apply(1);
                try {
                    some2 = new Some((Object)new AuthHeaderDetail(UUID.fromString(uuid), hash));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit3;
                        Throwable e = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(46).append("Bad format for UUID in authentication header: ").append(str).toString(), e);
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        some2 = None$.MODULE$;
                    }
                    throw throwable;
                }
                return some2;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Bad format for authentication header: {}", new Object[]{str});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Bad format for authentication header: {}", new Object[]{str});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    private String getQueryString(HttpRequest req) {
        return (String)req.uri().rawQueryString().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private String extractRequestHeader(HttpRequest request, String headerName) {
        Function<HttpHeader, String> f = new Function<HttpHeader, String>(null){

            public <V> Function<V, String> compose(Function<? super V, ? extends HttpHeader> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<HttpHeader, V> andThen(Function<? super String, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public String apply(HttpHeader h) {
                return h.value();
            }
        };
        return request.getHeader(headerName).map(f).orElse("");
    }

    public static /* synthetic */ Directive extractLatestAuthenticationHeaders$(MAuthDirectives $this, boolean v2OnlyAuthenticate) {
        return $this.extractLatestAuthenticationHeaders(v2OnlyAuthenticate);
    }

    default public Directive<Tuple1<MauthHeaderValues>> extractLatestAuthenticationHeaders(boolean v2OnlyAuthenticate) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest()), (Function1 & Serializable & scala.Serializable)request -> {
            String authenticationHeaderStr = this.extractRequestHeader((HttpRequest)request, "mcc-authentication");
            if (new StringOps(Predef$.MODULE$.augmentString(authenticationHeaderStr)).nonEmpty()) {
                String timeHeaderStr = this.extractRequestHeader((HttpRequest)request, "mcc-time");
                if (new StringOps(Predef$.MODULE$.augmentString(timeHeaderStr)).nonEmpty()) {
                    Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(timeHeaderStr)).toLong()).toOption();
                    if (option instanceof Some) {
                        long time;
                        Some some = (Some)option;
                        long l = time = BoxesRunTime.unboxToLong((Object)some.value());
                        return BasicDirectives$.MODULE$.provide((Object)new MauthHeaderValues(authenticationHeaderStr, l));
                    }
                    if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        String msg = new StringBuilder(44).append("mcc-time").append(" header supplied with bad format: [").append(timeHeaderStr).append("]").toString();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(msg);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection("mcc-time", msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
                    }
                    throw new MatchError((Object)option);
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("mcc-time")})), Tuple$.MODULE$.forTuple1());
            }
            if (!v2OnlyAuthenticate) {
                String authenticationHeaderStr2 = this.extractRequestHeader((HttpRequest)request, "x-mws-authentication");
                if (new StringOps(Predef$.MODULE$.augmentString(authenticationHeaderStr2)).nonEmpty()) {
                    String timeHeaderStr = this.extractRequestHeader((HttpRequest)request, "x-mws-time");
                    if (new StringOps(Predef$.MODULE$.augmentString(timeHeaderStr)).nonEmpty()) {
                        Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(timeHeaderStr)).toLong()).toOption();
                        if (option instanceof Some) {
                            long time;
                            Some some = (Some)option;
                            long l = time = BoxesRunTime.unboxToLong((Object)some.value());
                            return BasicDirectives$.MODULE$.provide((Object)new MauthHeaderValues(authenticationHeaderStr2, l));
                        }
                        if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit;
                            String msg = new StringBuilder(46).append("x-mws-time").append(" header supplied with bad format: [").append(timeHeaderStr).append("]").toString();
                            if (this.logger().underlying().isErrorEnabled()) {
                                this.logger().underlying().error(msg);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection("x-mws-time", msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
                        }
                        throw new MatchError((Object)option);
                    }
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("x-mws-time")})), Tuple$.MODULE$.forTuple1());
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("x-mws-authentication")})), Tuple$.MODULE$.forTuple1());
            }
            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("mcc-authentication")})), Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1());
    }

    public static void $init$(MAuthDirectives $this) {
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsAuthenticationHeader_$eq((Directive<Tuple1<String>>)Directives$.MODULE$.headerValueByName(X$minusMWS$minusAuthentication$.MODULE$.name()));
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMAuthHeader_$eq((Directive<Tuple1<AuthHeaderDetail>>)Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers($this.headerValueByTypeMdsol(HeaderMagnet$.MODULE$.fromUnitForModeledCustomHeader(BoxedUnit.UNIT, ClassTag$.MODULE$.apply(X.minusMWS.minusAuthentication.class), X$minusMWS$minusAuthentication$.MODULE$.implicitlyLocatableCompanion()))), (Function1 & Serializable & scala.Serializable)hdr -> {
            Some some;
            AuthHeaderDetail ahd;
            Option<AuthHeaderDetail> option = $this.extractAuthHeaderDetail(hdr.value());
            if (option instanceof Some && (ahd = (AuthHeaderDetail)(some = (Some)option).value()) != null) {
                AuthHeaderDetail authHeaderDetail = ahd;
                return BasicDirectives$.MODULE$.provide((Object)authHeaderDetail);
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                String msg = new StringBuilder(36).append(X$minusMWS$minusAuthentication$.MODULE$.name()).append(" header supplied with bad format: [").append(hdr.value()).append("]").toString();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection(X$minusMWS$minusAuthentication$.MODULE$.name(), msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            }
            throw new MatchError(option);
        }, Tuple$.MODULE$.forTuple1()));
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsTimeHeader_$eq((Directive<Tuple1<Object>>)Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers($this.headerValueByTypeMdsol(HeaderMagnet$.MODULE$.fromUnitForModeledCustomHeader(BoxedUnit.UNIT, ClassTag$.MODULE$.apply(X.minusMWS.minusTime.class), X$minusMWS$minusTime$.MODULE$.implicitlyLocatableCompanion()))), (Function1 & Serializable & scala.Serializable)time -> {
            Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(time.value())).toLong()).toOption();
            if (option instanceof Some) {
                long t;
                Some some = (Some)option;
                long l = t = BoxesRunTime.unboxToLong((Object)some.value());
                return BasicDirectives$.MODULE$.provide((Object)BoxesRunTime.boxToLong((long)l));
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                String msg = new StringBuilder(36).append(X$minusMWS$minusTime$.MODULE$.name()).append(" header supplied with bad format: [").append(time.value()).append("]").toString();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection(X$minusMWS$minusTime$.MODULE$.name(), msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            }
            throw new MatchError((Object)option);
        }, Tuple$.MODULE$.forTuple1()));
    }
}

