/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.params;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Set;
import liquibase.Scope;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.logging.Logger;

public class ParamsLoader {
    private static final Logger LOG = Scope.getCurrentScope().getLog(ParamsLoader.class);
    private static ClusterConfig liquibaseClickhouseProperties = null;
    private static Set<String> validProperties = new HashSet<String>(Arrays.asList("clusterName", "tableZooKeeperPathPrefix", "tableReplicaName"));

    private static StringBuilder appendWithComma(StringBuilder sb, String text) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(text);
        return sb;
    }

    private static String getMissingProperties(Set<String> properties) {
        StringBuilder missingProperties = new StringBuilder();
        for (String validProperty : validProperties) {
            if (properties.contains(validProperty)) continue;
            ParamsLoader.appendWithComma(missingProperties, validProperty);
        }
        return missingProperties.toString();
    }

    private static void checkProperties(Map<String, String> properties) throws InvalidPropertiesFormatException {
        StringBuilder errMsg = new StringBuilder();
        for (String key : properties.keySet()) {
            if (validProperties.contains(key)) continue;
            ParamsLoader.appendWithComma(errMsg, "unknown property: ").append(key);
        }
        if (errMsg.length() > 0 || properties.size() != validProperties.size()) {
            ParamsLoader.appendWithComma(errMsg, "the missing properties should be defined: ");
            errMsg.append(ParamsLoader.getMissingProperties(properties.keySet()));
        }
        if (errMsg.length() > 0) {
            throw new InvalidPropertiesFormatException(errMsg.toString());
        }
    }

    private static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static ClusterConfig getLiquibaseClickhouseProperties() {
        return ParamsLoader.getLiquibaseClickhouseProperties("liquibaseClickhouse");
    }

    public static ClusterConfig getLiquibaseClickhouseProperties(String configFile) {
        if (liquibaseClickhouseProperties != null) {
            return liquibaseClickhouseProperties;
        }
        Config conf = ConfigFactory.load((String)configFile);
        HashMap<String, String> params = new HashMap<String, String>();
        ClusterConfig result = null;
        try {
            for (Map.Entry s : conf.getConfig("cluster").entrySet()) {
                params.put((String)s.getKey(), ((ConfigValue)s.getValue()).unwrapped().toString());
            }
            ParamsLoader.checkProperties(params);
            result = new ClusterConfig((String)params.get("clusterName"), (String)params.get("tableZooKeeperPathPrefix"), (String)params.get("tableReplicaName"));
            LOG.info("Cluster settings (" + configFile + ".conf) are found. Work in cluster replicated clickhouse mode.");
        }
        catch (ConfigException.Missing e) {
            LOG.info("Cluster settings (" + configFile + ".conf) are not defined. Work in single-instance clickhouse mode.");
            LOG.info("The following properties should be defined: " + ParamsLoader.getMissingProperties(new HashSet<String>()));
        }
        catch (InvalidPropertiesFormatException e) {
            LOG.severe(ParamsLoader.getStackTrace(e));
            LOG.severe("Work in single-instance clickhouse mode.");
        }
        return result;
    }
}

