/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.RemoveChangeSetRanStatusGenerator;
import liquibase.statement.core.RemoveChangeSetRanStatusStatement;

public class RemoveChangeSetRanStatusClickHouse
extends RemoveChangeSetRanStatusGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(RemoveChangeSetRanStatusStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(RemoveChangeSetRanStatusStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        ChangeSet changeSet = statement.getChangeSet();
        String unlockQuery = String.format("ALTER TABLE %s.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "DELETE WHERE ID = '%s' AND AUTHOR = '%s' AND FILENAME = '%s'", database.getDefaultSchemaName(), database.getDatabaseChangeLogTableName(), changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath());
        return SqlGeneratorUtil.generateSql(database, unlockQuery);
    }
}

