/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.TagDatabaseGenerator;
import liquibase.statement.core.TagDatabaseStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;

public class TagDatabaseGeneratorClickhouse
extends TagDatabaseGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(TagDatabaseStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(TagDatabaseStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String tableNameEscaped = database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName());
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        String orderColumnNameEscaped = database.escapeObjectName("ORDEREXECUTED", Column.class);
        String dateColumnNameEscaped = database.escapeObjectName("DATEEXECUTED", Column.class);
        String tagEscaped = DataTypeFactory.getInstance().fromObject((Object)statement.getTag(), database).objectToSql((Object)statement.getTag(), database);
        return new Sql[]{new UnparsedSql("ALTER TABLE " + tableNameEscaped + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + " UPDATE TAG=" + tagEscaped + " WHERE " + dateColumnNameEscaped + "=(SELECT " + dateColumnNameEscaped + " FROM " + tableNameEscaped + " ORDER BY " + dateColumnNameEscaped + " DESC, " + orderColumnNameEscaped + " DESC LIMIT 1) AND " + orderColumnNameEscaped + "=(SELECT " + orderColumnNameEscaped + " FROM " + tableNameEscaped + " ORDER BY " + dateColumnNameEscaped + " DESC, " + orderColumnNameEscaped + " DESC LIMIT 1)", new DatabaseObject[0])};
    }
}

