/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.UnlockDatabaseChangeLogGenerator;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;

public class UnlockDatabaseChangelogClickHouse
extends UnlockDatabaseChangeLogGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(UnlockDatabaseChangeLogStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(UnlockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        String unlockQuery = String.format("ALTER TABLE %s.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "UPDATE LOCKED = 0,LOCKEDBY = null, LOCKGRANTED = null WHERE ID = 1 AND LOCKED = 1", database.getDefaultSchemaName(), database.getDatabaseChangeLogLockTableName());
        return SqlGeneratorUtil.generateSql(database, unlockQuery);
    }
}

