/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.UpdateChangeSetChecksumGenerator;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;

public class UpdateChangeSetChecksumClickHouse
extends UpdateChangeSetChecksumGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(UpdateChangeSetChecksumStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(UpdateChangeSetChecksumStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        ChangeSet changeSet = statement.getChangeSet();
        String updateChecksumQuery = String.format("ALTER TABLE %s.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "UPDATE MD5SUM = '%s' WHERE ID = '%s' AND AUTHOR = '%s' AND FILENAME = '%s'", database.getDefaultSchemaName(), database.getDatabaseChangeLogTableName(), changeSet.generateCheckSum().toString(), changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath());
        return SqlGeneratorUtil.generateSql(database, updateChecksumQuery);
    }
}

