/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.Version;
import com.meilisearch.sdk.json.GsonJsonHandler;
import com.meilisearch.sdk.json.JsonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Config {
    protected final String hostUrl;
    protected final String apiKey;
    protected final HttpClient httpClient;
    protected final Map<String, String> headers;
    protected JsonHandler jsonHandler;

    public Config(String hostUrl) {
        this(hostUrl, "");
    }

    public Config(String hostUrl, String apiKey) {
        this(hostUrl, apiKey, new GsonJsonHandler(), new String[0]);
    }

    public Config(String hostUrl, String apiKey, JsonHandler jsonHandler) {
        this(hostUrl, apiKey, jsonHandler, new String[0]);
    }

    public Config(String hostUrl, String apiKey, String[] clientAgents) {
        this(hostUrl, apiKey, new GsonJsonHandler(), clientAgents);
    }

    public Config(String hostUrl, String apiKey, JsonHandler jsonHandler, String[] clientAgents) {
        this.hostUrl = hostUrl;
        this.apiKey = apiKey;
        this.headers = this.configHeaders(clientAgents);
        this.jsonHandler = jsonHandler;
        this.httpClient = new HttpClient(this);
    }

    public String getBearerApiKey() {
        return "Bearer " + this.apiKey;
    }

    private Map<String, String> configHeaders(String[] clientAgents) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(clientAgents));
        list.add(0, Version.getQualifiedVersion());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("User-Agent", String.join((CharSequence)";", list));
        return data;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public void setJsonHandler(JsonHandler jsonHandler) {
        this.jsonHandler = jsonHandler;
    }
}

